/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;

public class ContentStreamUpdateRequest
extends AbstractUpdateRequest {
    List<ContentStream> contentStreams = new ArrayList<ContentStream>();

    public ContentStreamUpdateRequest(String url) {
        super(SolrRequest.METHOD.POST, url);
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return this.contentStreams;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
        if (this.contentStreams == null || this.contentStreams.isEmpty() || this.contentStreams.size() > 1) {
            return null;
        }
        final ContentStream stream = this.contentStreams.get(0);
        return new RequestWriter.ContentWriter(){

            @Override
            public void write(OutputStream os) throws IOException {
                try (InputStream inStream = stream.getStream();){
                    IOUtils.copy((InputStream)inStream, (OutputStream)os);
                }
            }

            @Override
            public String getContentType() {
                return stream.getContentType();
            }
        };
    }

    public void addFile(File file, String contentType) throws IOException {
        ContentStreamBase.FileStream cs = new ContentStreamBase.FileStream(file);
        cs.setContentType(contentType);
        this.addContentStream(cs);
    }

    public void addContentStream(ContentStream contentStream) {
        this.contentStreams.add(contentStream);
    }
}

