/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;

public class ExGUIDArray
extends BasicObject {
    public Compact64bitInt count = new Compact64bitInt();
    public List<ExGuid> content = new ArrayList<ExGuid>();

    public ExGUIDArray(List<ExGuid> content) {
        this();
        this.content = new ArrayList<ExGuid>();
        if (content != null) {
            for (ExGuid extendGuid : content) {
                this.content.add(new ExGuid(extendGuid));
            }
        }
        this.count.setDecodedValue(this.content.size());
    }

    public ExGUIDArray(ExGUIDArray extendGuidArray) {
        this(extendGuidArray.content);
    }

    public ExGUIDArray() {
    }

    public List<ExGuid> getContent() {
        return this.content;
    }

    public void setContent(List<ExGuid> content) {
        this.content = content;
        this.count.setDecodedValue(this.content.size());
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        this.count.setDecodedValue(this.content.size());
        ArrayList<Byte> result = new ArrayList<Byte>();
        result.addAll(this.count.serializeToByteList());
        for (ExGuid extendGuid : this.content) {
            result.addAll(extendGuid.serializeToByteList());
        }
        return result;
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        this.count = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        this.content.clear();
        int i = 0;
        while ((long)i < this.count.getDecodedValue()) {
            ExGuid temp = BasicObject.parse(byteArray, index, ExGuid.class);
            this.content.add(temp);
            ++i;
        }
        return index.get() - startIndex;
    }
}

