/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.Field;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.util.ArgumentChecks;

public class QuantityFormat
extends Format {
    private static final long serialVersionUID = 1014042719969477503L;
    public static final char SEPARATOR = '\u202f';
    protected final NumberFormat numberFormat;
    protected final UnitFormat unitFormat;

    public QuantityFormat(Locale locale) {
        ArgumentChecks.ensureNonNull("locale", locale);
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.unitFormat = new UnitFormat(locale);
    }

    public QuantityFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        ArgumentChecks.ensureNonNull("numberFormat", numberFormat);
        ArgumentChecks.ensureNonNull("unitFormat", unitFormat);
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        Quantity quantity = (Quantity)object;
        if (fieldPosition == null) {
            fieldPosition = new FieldPosition(0);
        }
        stringBuffer = this.numberFormat.format(quantity.getValue(), stringBuffer, fieldPosition).append('\u202f');
        stringBuffer = this.unitFormat.format(quantity.getUnit(), stringBuffer, fieldPosition);
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        Unit<?> unit;
        Number number = this.numberFormat.parse(string, parsePosition);
        if (number != null && (unit = this.unitFormat.parse(string, parsePosition)) != null) {
            return Quantities.create(number.doubleValue(), unit);
        }
        return null;
    }

    @Override
    public QuantityFormat clone() {
        QuantityFormat quantityFormat = (QuantityFormat)super.clone();
        try {
            Field field = QuantityFormat.class.getField("numberFormat");
            field.setAccessible(true);
            field.set(quantityFormat, this.numberFormat.clone());
            field = QuantityFormat.class.getField("unitFormat");
            field.setAccessible(true);
            field.set(quantityFormat, this.unitFormat.clone());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
        return quantityFormat;
    }
}

