/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.jts.JTS;
import org.apache.sis.internal.feature.jts.Wrapper;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTReader;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 3457343016410620076L;
    public static final Factory INSTANCE = new Factory();
    private final transient GeometryFactory factory = new GeometryFactory();

    @Override
    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.JTS, Geometry.class, Point.class, LineString.class, Polygon.class);
    }

    @Override
    public Class<?> getGeometryClass(GeometryType geometryType) {
        switch (geometryType) {
            default: {
                return this.rootClass;
            }
            case POINT: {
                return this.pointClass;
            }
            case LINESTRING: {
                return this.polylineClass;
            }
            case POLYGON: {
                return this.polygonClass;
            }
            case MULTI_POINT: {
                return MultiPoint.class;
            }
            case MULTI_LINESTRING: {
                return MultiLineString.class;
            }
            case MULTI_POLYGON: 
        }
        return MultiPolygon.class;
    }

    @Override
    public GeometryWrapper<Geometry> castOrWrap(Object object) {
        return object == null || object instanceof Wrapper ? (Wrapper)object : new Wrapper((Geometry)object);
    }

    @Override
    protected GeometryWrapper<Geometry> createWrapper(Geometry geometry) {
        return new Wrapper(geometry);
    }

    @Override
    public Object createPoint(double d, double d2) {
        return this.factory.createPoint(new Coordinate(d, d2));
    }

    @Override
    public Object createPoint(double d, double d2, double d3) {
        return this.factory.createPoint(new Coordinate(d, d2, d3));
    }

    @Override
    public Geometry createPolyline(boolean bl, int n, Vector ... vectorArray) {
        boolean bl2;
        boolean bl3 = bl2 = n == 3;
        if (!bl2 && n != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(n));
        }
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(32);
        ArrayList<Geometry> arrayList2 = new ArrayList<Geometry>();
        for (Vector vector : vectorArray) {
            if (vector == null) continue;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                double d = vector.doubleValue(n3++);
                double d2 = vector.doubleValue(n3++);
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    Coordinate coordinate = bl2 ? new Coordinate(d, d2, vector.doubleValue(n3++)) : new Coordinate(d, d2);
                    arrayList.add(coordinate);
                    continue;
                }
                if (bl2) {
                    ++n3;
                }
                this.toLineString(arrayList, arrayList2, bl);
                arrayList.clear();
            }
        }
        this.toLineString(arrayList, arrayList2, bl);
        return this.toGeometry(arrayList2, bl);
    }

    @Override
    public GeometryWrapper<Geometry> createMultiPolygon(Object[] objectArray) {
        Polygon[] polygonArray = new Polygon[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Polygon polygon;
            Object object = Factory.unwrap(objectArray[i]);
            if (object instanceof Polygon) {
                polygon = (Polygon)object;
            } else if (object instanceof LinearRing) {
                polygon = this.factory.createPolygon((LinearRing)object);
                JTS.copyMetadata((Geometry)object, (Geometry)polygon);
            } else if (object instanceof LineString) {
                polygon = this.factory.createPolygon(((LineString)object).getCoordinateSequence());
                JTS.copyMetadata((Geometry)object, (Geometry)polygon);
            } else {
                throw new ClassCastException(Errors.format((short)43, Strings.bracket("geometries", (Object)i), Polygon.class, Classes.getClass(object)));
            }
            polygonArray[i] = polygon;
        }
        return new Wrapper((Geometry)this.factory.createMultiPolygon(polygonArray));
    }

    final void toLineString(List<Coordinate> list, List<Geometry> list2, boolean bl) {
        int n = list.size();
        if (n >= 2) {
            Coordinate[] coordinateArray = list.toArray(new Coordinate[n]);
            Object object = bl ? this.factory.createPolygon(coordinateArray) : (coordinateArray.length > 3 && coordinateArray[0].equals2D(coordinateArray[n - 1]) ? this.factory.createLinearRing(coordinateArray) : this.factory.createLineString(coordinateArray));
            list2.add((Geometry)object);
        }
    }

    final Geometry toGeometry(List<Geometry> list, boolean bl) {
        int n = list.size();
        switch (n) {
            case 0: {
                return bl ? this.factory.createPolygon((Coordinate[])null) : this.factory.createLinearRing((Coordinate[])null);
            }
            case 1: {
                return list.get(0);
            }
        }
        return bl ? this.factory.createMultiPolygon(list.toArray(new Polygon[n])) : this.factory.createMultiLineString(list.toArray(new LineString[n]));
    }

    @Override
    public GeometryWrapper<Geometry> createFromComponents(GeometryType geometryType, Object object) {
        GeometryCollection geometryCollection;
        block0 : switch (geometryType) {
            case GEOMETRY_COLLECTION: {
                geometryCollection = this.factory.createGeometryCollection((Geometry[])object);
                break;
            }
            case MULTI_LINESTRING: {
                geometryCollection = this.factory.createMultiLineString((LineString[])object);
                break;
            }
            case MULTI_POLYGON: {
                geometryCollection = this.factory.createMultiPolygon((Polygon[])object);
                break;
            }
            case MULTI_POINT: {
                if (object instanceof Point[]) {
                    geometryCollection = this.factory.createMultiPoint((Point[])object);
                    break;
                }
            }
            default: {
                CoordinateSequence coordinateSequence;
                if (object instanceof CoordinateSequence) {
                    coordinateSequence = (CoordinateSequence)object;
                } else {
                    Coordinate[] coordinateArray;
                    if (object instanceof Coordinate[]) {
                        coordinateArray = (Coordinate[])object;
                    } else {
                        List<Object> list = object instanceof Collection ? (List<Object>)object : Arrays.asList((Object[])object);
                        coordinateArray = new Coordinate[list.size()];
                        int n = 0;
                        for (Object e : list) {
                            coordinateArray[n++] = e instanceof Point ? ((Point)e).getCoordinate() : (Coordinate)e;
                        }
                    }
                    coordinateSequence = this.factory.getCoordinateSequenceFactory().create(coordinateArray);
                }
                switch (geometryType) {
                    case MULTI_POINT: 
                    case GEOMETRY: {
                        geometryCollection = this.factory.createMultiPoint(coordinateSequence);
                        break block0;
                    }
                    case LINESTRING: {
                        geometryCollection = this.factory.createLineString(coordinateSequence);
                        break block0;
                    }
                    case POLYGON: {
                        geometryCollection = this.factory.createPolygon(coordinateSequence);
                        break block0;
                    }
                    case POINT: {
                        geometryCollection = this.factory.createMultiPoint(coordinateSequence).getCentroid();
                        break block0;
                    }
                }
                throw new AssertionError((Object)geometryType);
            }
        }
        return new Wrapper((Geometry)geometryCollection);
    }

    @Override
    public GeometryWrapper<Geometry> parseWKT(String string) throws ParseException {
        return new Wrapper(new WKTReader(this.factory).read(string));
    }

    @Override
    public GeometryWrapper<Geometry> parseWKB(ByteBuffer byteBuffer) throws ParseException {
        byte[] byArray;
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset();
            int n2 = byteBuffer.limit() + n;
            if ((n += byteBuffer.position()) != 0 || n2 != byArray.length) {
                byArray = Arrays.copyOfRange(byArray, n, n2);
            }
        } else {
            byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
        }
        return new Wrapper(new WKBReader(this.factory).read(byArray));
    }
}

