/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AzimuthalEquidistant;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class ModifiedAzimuthalEquidistant
extends AzimuthalEquidistant {
    private static final long serialVersionUID = 96569177715708509L;
    private final double \u212f2_\u03bd0_sin\u03c60;
    private final double G;
    private final double Hp;
    private final double Bp;

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.internal.referencing.provider.ModifiedAzimuthalEquidistant.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, org.apache.sis.internal.referencing.provider.ModifiedAzimuthalEquidistant.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, org.apache.sis.internal.referencing.provider.ModifiedAzimuthalEquidistant.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, 0);
    }

    public ModifiedAzimuthalEquidistant(OperationMethod operationMethod, Parameters parameters) {
        this(ModifiedAzimuthalEquidistant.initializer(operationMethod, parameters));
    }

    private ModifiedAzimuthalEquidistant(Initializer initializer) {
        super(initializer);
        double d = initializer.axisLengthRatio().doubleValue();
        double d2 = initializer.radiusOfCurvature(this.sin\u03c60);
        this.\u212f2_\u03bd0_sin\u03c60 = this.eccentricitySquared * d2 * this.sin\u03c60;
        double d3 = this.eccentricity / d;
        this.G = d3 * this.sin\u03c60;
        this.Hp = d3 * this.cos\u03c60;
        this.Bp = 3.0 * this.eccentricitySquared * (this.sin\u03c60 * this.cos\u03c60) / (1.0 - this.eccentricitySquared);
        MatrixSIS matrixSIS = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        matrixSIS.convertBefore(0, d2, null);
        matrixSIS.convertBefore(1, d2, null);
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        AzimuthalEquidistant azimuthalEquidistant = this;
        if (this.eccentricity == 0.0) {
            azimuthalEquidistant = new AzimuthalEquidistant(this);
        }
        return this.context.completeTransform(mathTransformFactory, azimuthalEquidistant);
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2 = dArray[n];
        double d3 = dArray[n + 1];
        double d4 = Math.cos(d2);
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d3);
        double d7 = Math.sin(d3);
        double d8 = Math.sqrt(1.0 - this.eccentricitySquared * (d7 * d7));
        double d9 = ((1.0 - this.eccentricitySquared) * d7 + this.\u212f2_\u03bd0_sin\u03c60 * d8) / d6;
        double d10 = Math.sqrt(1.0 + d9 * d9);
        double d11 = Math.atan2(d5, this.cos\u03c60 * d9 - this.sin\u03c60 * d4);
        double d12 = Math.sin(d11);
        double d13 = Math.cos(d11);
        double d14 = d13 * this.Hp;
        if (Math.abs(d12) < 1.5706706731410455E-9) {
            d = (this.cos\u03c60 * d9 - this.sin\u03c60) / d10;
            if (d13 < 0.0) {
                d = -d;
            }
        } else {
            d = d5 / (d10 * d12);
        }
        d = Math.asin(d);
        double d15 = d * d;
        double d16 = d15 * d;
        double d17 = d15 * d15;
        double d18 = d17 * d;
        double d19 = d14 * d14;
        double d20 = this.G * d14;
        d *= 1.0 - d15 / 6.0 * d19 * (1.0 - d19) + d16 / 8.0 * d20 * (1.0 - 2.0 * d19) + d17 / 120.0 * (d19 * (4.0 - 7.0 * d19) - 3.0 * (this.G * this.G) * (1.0 - 7.0 * d19)) - d18 / 48.0 * d20;
        if (dArray2 != null) {
            dArray2[n2] = d * d12;
            dArray2[n2 + 1] = d * d13;
        }
        if (!bl) {
            return null;
        }
        throw new ProjectionException("Derivative not yet implemented.");
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = d * d + d2 * d2;
        double d4 = Math.sqrt(d3);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d4 != 0.0) {
            d5 = d / d4;
            d6 = d2 / d4;
        }
        double d7 = this.Hp * d6;
        d7 *= d7;
        double d8 = this.Bp * (1.0 + d7) * d6;
        double d9 = d4 + d7 * (1.0 - d7) * (d3 * d4) / 6.0 - d8 * (1.0 - 3.0 * d7) * (d3 * d3) / 24.0;
        double d10 = d9 * d9;
        double d11 = 1.0 + d7 * d10 / 2.0 - d8 * (d10 * d9) / 6.0;
        double d12 = Math.sin(d9);
        double d13 = this.sin\u03c60 * Math.cos(d9) + this.cos\u03c60 * d12 * d6;
        double d14 = Math.sqrt(1.0 - d13 * d13);
        dArray2[n2] = Math.asin(d5 * d12 / d14);
        dArray2[n2 + 1] = Math.atan((1.0 - this.eccentricitySquared * this.sin\u03c60 * d11 / d13) * (d13 / d14) / (1.0 - this.eccentricitySquared));
    }
}

