/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import org.exolab.castor.util.OrderedHashMap;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JSourceWriter;

public final class JAnnotation {
    private JAnnotationType _annotationType;
    private OrderedHashMap _elementValues = new OrderedHashMap();
    public static final String VALUE = "value";

    public JAnnotation(JAnnotationType annotationType) {
        this._annotationType = annotationType;
    }

    public JAnnotationType getAnnotationType() {
        return this._annotationType;
    }

    public void setValue(String stringValue) {
        this._elementValues.put(VALUE, stringValue);
    }

    public void setValue(String[] stringValue) {
        this._elementValues.put(VALUE, stringValue);
    }

    public void setValue(JAnnotation annotationValue) {
        this._elementValues.put(VALUE, annotationValue);
    }

    public void setValue(JAnnotation[] annotationValues) {
        this._elementValues.put(VALUE, annotationValues);
    }

    public void setElementValue(String elementName, String stringValue) {
        this._elementValues.put(elementName, stringValue);
    }

    public void setElementValue(String elementName, String[] stringValues) {
        this._elementValues.put(elementName, stringValues);
    }

    public void setElementValue(String elementName, JAnnotation annotationValue) {
        this._elementValues.put(elementName, annotationValue);
    }

    public void setElementValue(String elementName, JAnnotation[] annotationValues) {
        this._elementValues.put(elementName, annotationValues);
    }

    public String getValue() {
        Object elementValue = this.getElementValueObject(VALUE);
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        throw new IllegalStateException("'value' element is not of type String.");
    }

    public JAnnotation getValueAnnotation() {
        Object elementValue = this.getElementValueObject(VALUE);
        if (elementValue instanceof JAnnotation) {
            return (JAnnotation)elementValue;
        }
        throw new IllegalStateException("'value' element is not of type JAnnotation.");
    }

    public String getElementValue(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type String.");
    }

    public String[] getElementValueList(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof String[]) {
            return (String[])elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type String[].");
    }

    public Object getElementValueObject(String elementName) {
        return this._elementValues.get(elementName);
    }

    public JAnnotation getElementValueAnnotation(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof JAnnotation) {
            return (JAnnotation)elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type JAnnotation.");
    }

    public JAnnotation[] getElementValueAnnotationList(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof JAnnotation[]) {
            return (JAnnotation[])elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type JAnnotation[].");
    }

    public String[] getElementNames() {
        return this._elementValues.keySet().toArray(new String[this._elementValues.size()]);
    }

    public void print(JSourceWriter jsw) {
        jsw.write("@");
        jsw.write(this._annotationType.getLocalName());
        jsw.write("(");
        String[] elementNames = this.getElementNames();
        if (elementNames.length == 1 && elementNames[0].equals(VALUE)) {
            this.printElementValue(jsw, this.getElementValueObject(VALUE));
        } else if (elementNames.length > 0) {
            int elementNameLength;
            int i;
            int maxLength = 0;
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                if (elementNameLength <= maxLength) continue;
                maxLength = elementNameLength;
            }
            jsw.writeln();
            jsw.indent();
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                jsw.write(elementNames[i]);
                for (int p = 0; p < maxLength - elementNameLength; ++p) {
                    jsw.write(" ");
                }
                jsw.write(" = ");
                this.printElementValue(jsw, this.getElementValueObject(elementNames[i]));
                if (i >= elementNames.length - 1) continue;
                jsw.write(",");
                jsw.writeln();
            }
            jsw.unindent();
        }
        jsw.write(")");
    }

    private void printElementValue(JSourceWriter jsw, Object elementValue) {
        if (elementValue instanceof String) {
            jsw.write((String)elementValue);
            return;
        }
        if (elementValue instanceof JAnnotation) {
            JAnnotation annotation = (JAnnotation)elementValue;
            annotation.print(jsw);
            return;
        }
        if (elementValue.getClass().isArray()) {
            int listLength = Array.getLength(elementValue);
            if (listLength == 1) {
                this.printElementValue(jsw, Array.get(elementValue, 0));
                return;
            }
            jsw.indent();
            jsw.writeln();
            jsw.write("{");
            jsw.writeln();
            jsw.indent();
            for (int i = 0; i < listLength; ++i) {
                this.printElementValue(jsw, Array.get(elementValue, i));
                if (i < listLength - 1) {
                    jsw.write(",");
                }
                jsw.writeln();
            }
            jsw.unindent();
            jsw.write("}");
            jsw.unindent();
            return;
        }
        throw new IllegalArgumentException("'" + elementValue + "' was not expected.");
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JAnnotation.test1(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test2(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test3(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test4(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test5(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test6(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test7(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotation.test8(jsw);
        jsw.flush();
    }

    private static void test1(JSourceWriter jsw) {
        JAnnotationType requestForEnhancementType1 = new JAnnotationType("RequestForEnhancement");
        JAnnotation requestForEnhancement1 = new JAnnotation(requestForEnhancementType1);
        requestForEnhancement1.setElementValue("id", "2868724");
        requestForEnhancement1.setElementValue("synopsis", "\"Provide time-travel functionality\"");
        requestForEnhancement1.setElementValue("engineer", "\"Mr. Peabody\"");
        requestForEnhancement1.setElementValue("date", "\"4/1/2004\"");
        requestForEnhancement1.print(jsw);
    }

    private static void test2(JSourceWriter jsw) {
        JAnnotationType webMethodType2 = new JAnnotationType("WebMethod");
        JAnnotation webMethod2 = new JAnnotation(webMethodType2);
        webMethod2.print(jsw);
    }

    private static void test3(JSourceWriter jsw) {
        JAnnotationType copyrightType3 = new JAnnotationType("Copyright");
        JAnnotation copyright3 = new JAnnotation(copyrightType3);
        copyright3.setValue("\"2002 Yoyodyne Propulsion Systems, Inc., All rights reserved.\"");
        copyright3.print(jsw);
    }

    private static void test4(JSourceWriter jsw) {
        JAnnotationType endorsersType4 = new JAnnotationType("Endorsers");
        JAnnotation endorsers4 = new JAnnotation(endorsersType4);
        endorsers4.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        endorsers4.print(jsw);
    }

    private static void test5(JSourceWriter jsw) {
        JAnnotationType endorsersType5 = new JAnnotationType("Endorsers");
        JAnnotation endorsers5 = new JAnnotation(endorsersType5);
        endorsers5.setValue(new String[]{"\"Epicurus\""});
        endorsers5.print(jsw);
    }

    private static void test6(JSourceWriter jsw) {
        JAnnotationType nameType6 = new JAnnotationType("Name");
        JAnnotationType authorType6 = new JAnnotationType("Author");
        JAnnotation author6 = new JAnnotation(authorType6);
        JAnnotation name6 = new JAnnotation(nameType6);
        name6.setElementValue("first", "\"Joe\"");
        name6.setElementValue("last", "\"Hacker\"");
        author6.setValue(name6);
        author6.print(jsw);
    }

    private static void test7(JSourceWriter jsw) {
        JAnnotationType nameType7 = new JAnnotationType("Name");
        JAnnotationType authorType7 = new JAnnotationType("Author");
        JAnnotation author7 = new JAnnotation(authorType7);
        JAnnotation name7 = new JAnnotation(nameType7);
        name7.setElementValue("first", "\"Joe\"");
        name7.setElementValue("last", "\"Hacker\"");
        author7.setElementValue("name", name7);
        author7.setElementValue("rating", "Rating.GOOD");
        author7.print(jsw);
    }

    private static void test8(JSourceWriter jsw) {
        JAnnotationType nameType8 = new JAnnotationType("Name");
        JAnnotationType authorType8 = new JAnnotationType("Author");
        JAnnotation author8 = new JAnnotation(authorType8);
        JAnnotation name81 = new JAnnotation(nameType8);
        name81.setElementValue("first", "\"Joe\"");
        name81.setElementValue("last", "\"Hacker\"");
        JAnnotation name82 = new JAnnotation(nameType8);
        name82.setElementValue("first", "\"Joe\"");
        name82.setElementValue("last", "\"Blogs\"");
        author8.setElementValue("name", new JAnnotation[]{name81, name82});
        author8.setElementValue("rating", "Rating.GOOD");
        author8.print(jsw);
    }
}

