/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BuildInfo {
    private static final Properties BUILD_PROPERTIES = BuildInfo.loadBuildProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        Manifest manifest = null;
        ZipFile jar = null;
        try {
            URL url = BuildInfo.class.getProtectionDomain().getCodeSource().getLocation();
            File file = new File(url.toURI());
            jar = new JarFile(file);
            ZipEntry entry = ((JarFile)jar).getEntry("META-INF/build-stamp.properties");
            if (entry != null) {
                try (InputStream stream = ((JarFile)jar).getInputStream(entry);){
                    properties.load(stream);
                }
            }
            manifest = ((JarFile)jar).getManifest();
        }
        catch (IOException | IllegalArgumentException | NullPointerException | URISyntaxException url) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException url) {}
            }
        }
        if (manifest == null) {
            return properties;
        }
        try {
            Attributes attributes = manifest.getAttributes("Build-Info");
            Set<Map.Entry<Object, Object>> entries = attributes.entrySet();
            for (Map.Entry<Object, Object> e : entries) {
                properties.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
            attributes = manifest.getAttributes("Selenium");
            entries = attributes.entrySet();
            for (Map.Entry<Object, Object> e : entries) {
                properties.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return properties;
    }

    public String getReleaseLabel() {
        return BUILD_PROPERTIES.getProperty("Selenium-Version", "unknown").trim();
    }

    public String getBuildRevision() {
        return BUILD_PROPERTIES.getProperty("Build-Revision", "unknown");
    }

    public String getBuildTime() {
        return BUILD_PROPERTIES.getProperty("Build-Time", "unknown");
    }

    public String toString() {
        return String.format("Build info: version: '%s', revision: '%s', time: '%s'", this.getReleaseLabel(), this.getBuildRevision(), this.getBuildTime());
    }
}

