/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LoggingHandler;

class HandlerBasedLocalLogs
extends LocalLogs {
    private final LoggingHandler loggingHandler;
    private final Set<String> logTypesToInclude;

    protected HandlerBasedLocalLogs(LoggingHandler loggingHandler, Set<String> logTypesToInclude) {
        this.loggingHandler = loggingHandler;
        this.logTypesToInclude = logTypesToInclude;
    }

    @Override
    public LogEntries get(String logType) {
        if ("client".equals(logType) && this.logTypesToInclude.contains(logType)) {
            Collection<LogEntry> entries = this.loggingHandler.getRecords();
            this.loggingHandler.flush();
            return new LogEntries(entries);
        }
        return new LogEntries(Collections.emptyList());
    }

    public Set<String> getAvailableLogTypes() {
        return ImmutableSet.of((Object)"client");
    }

    @Override
    public void addEntry(String logType, LogEntry entry) {
        throw new RuntimeException("Log to this instance of LocalLogs using standard Java logging.");
    }
}

