/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;

public enum Dialect {
    ANSI(null, false, true),
    DERBY("derby", false, true),
    HSQL("hsqldb", false, true),
    POSTGRESQL("postgresql", true, true),
    ORACLE("oracle", false, true),
    SQLITE("sqlite", false, false);

    private final String protocol;
    public final boolean supportsTableInheritance;
    public final boolean supportsIndexInheritance = false;
    public final boolean supportsAlterTableWithAddConstraint;

    private Dialect(String string2, boolean bl, boolean bl2) {
        this.protocol = string2;
        this.supportsTableInheritance = bl;
        this.supportsAlterTableWithAddConstraint = bl2;
    }

    public static Dialect guess(DatabaseMetaData databaseMetaData) throws SQLException {
        int n;
        int n2;
        String string = databaseMetaData.getURL();
        if (string != null && (n2 = string.indexOf(58)) >= 0 && "jdbc".equalsIgnoreCase((String)CharSequences.trimWhitespaces(string, 0, n2)) && (n = string.indexOf(58, ++n2)) >= 0) {
            String string2 = (String)CharSequences.trimWhitespaces(string, n2, n);
            for (Dialect dialect : Dialect.values()) {
                if (!string2.equalsIgnoreCase(dialect.protocol)) continue;
                return dialect;
            }
        }
        return ANSI;
    }
}

