/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities;

import org.apache.manifoldcf.authorities.BaseDomainsInitializationCommand;
import org.apache.manifoldcf.authorities.interfaces.IAuthorizationDomainManager;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class RegisterDomain
extends BaseDomainsInitializationCommand {
    public static final String _rcsid = "@(#)$Id$";
    private final String domainName;
    private final String description;

    public RegisterDomain(String domainName, String description) {
        this.domainName = domainName;
        this.description = description;
    }

    @Override
    protected void doExecute(IAuthorizationDomainManager mgr) throws ManifoldCFException {
        mgr.registerDomain(this.description, this.domainName);
        Logging.root.info((Object)("Successfully registered authorization domain '" + this.domainName + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: RegisterDomain <domainname> <description>");
            System.exit(1);
        }
        String domainName = args[0];
        String description = args[1];
        try {
            RegisterDomain registerDomain = new RegisterDomain(domainName, description);
            registerDomain.execute();
            System.err.println("Successfully registered authorization domain '" + domainName + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

