/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.faces.FacesWrapper;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.el.LocationAware;

public class LocationMethodExpression
extends MethodExpression
implements FacesWrapper<MethodExpression>,
Externalizable,
LocationAware {
    private static final long serialVersionUID = 1634644578979226893L;
    private Location location;
    private MethodExpression delegate;
    int ccLevel;

    public LocationMethodExpression() {
    }

    public LocationMethodExpression(Location location, MethodExpression delegate) {
        this.location = location;
        this.delegate = delegate;
        this.ccLevel = 0;
    }

    public LocationMethodExpression(Location location, MethodExpression delegate, int ccLevel) {
        this.location = location;
        this.delegate = delegate;
        this.ccLevel = ccLevel;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public LocationMethodExpression apply(int newCCLevel) {
        if (this.ccLevel == newCCLevel) {
            return this;
        }
        return new LocationMethodExpression(this.location, this.delegate, newCCLevel);
    }

    public LocationMethodExpression apply(int newCCLevel, Location newLocation) {
        if (this.ccLevel == newCCLevel && this.location.getPath().equals(newLocation.getPath())) {
            return this;
        }
        return new LocationMethodExpression(newLocation, this.delegate, newCCLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getMethodInfo(ELContext context) {
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        CompositeComponentELUtils.saveCompositeComponentForResolver(facesContext, this.location, this.ccLevel);
        try {
            MethodInfo methodInfo = this.delegate.getMethodInfo(context);
            return methodInfo;
        }
        finally {
            CompositeComponentELUtils.removeCompositeComponentForResolver(facesContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext context, Object[] params) {
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        CompositeComponentELUtils.saveCompositeComponentForResolver(facesContext, this.location, this.ccLevel);
        try {
            Object object = this.delegate.invoke(context, params);
            return object;
        }
        finally {
            CompositeComponentELUtils.removeCompositeComponentForResolver(facesContext);
        }
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isLiteralText() {
        return this.delegate.isLiteralText();
    }

    public MethodExpression getWrapped() {
        return this.delegate;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MethodExpression)in.readObject();
        this.location = (Location)in.readObject();
        this.ccLevel = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
        out.writeObject(this.location);
        out.writeInt(this.ccLevel);
    }
}

