/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces;

import jakarta.el.MethodExpression;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.MethodExpressionValueChangeListener;
import jakarta.faces.event.ValueChangeEvent;
import jakarta.faces.validator.MethodExpressionValidator;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.TagAttribute;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.tag.faces.PartialMethodExpressionValidator;
import org.apache.myfaces.view.facelets.tag.faces.PartialMethodExpressionValueChangeListener;

public final class EditableValueHolderRule
extends MetaRule {
    private static final Class<?>[] VALIDATOR_SIG = new Class[]{FacesContext.class, UIComponent.class, Object.class};
    private static final Class<?>[] VALUECHANGE_SIG = new Class[]{ValueChangeEvent.class};
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final EditableValueHolderRule INSTANCE = new EditableValueHolderRule();

    @Override
    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(EditableValueHolder.class)) {
            if ("validator".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralValidatorMetadata(attribute.getValue());
                }
                return new ValidatorExpressionMetadata(attribute);
            }
            if ("valueChangeListener".equals(name)) {
                return new ValueChangedExpressionMetadata(attribute);
            }
        }
        return null;
    }

    static final class LiteralValidatorMetadata
    extends Metadata {
        private final String validatorId;

        public LiteralValidatorMetadata(String validatorId) {
            this.validatorId = validatorId;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((EditableValueHolder)instance).addValidator(ctx.getFacesContext().getApplication().createValidator(this.validatorId));
        }
    }

    static final class ValidatorExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValidatorExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (FaceletCompositionContext.getCurrentInstance(ctx).isUsingPSSOnThisView()) {
                ((EditableValueHolder)instance).addValidator(new PartialMethodExpressionValidator(this.attr.getMethodExpression(ctx, null, VALIDATOR_SIG)));
            } else {
                ((EditableValueHolder)instance).addValidator(new MethodExpressionValidator(this.attr.getMethodExpression(ctx, null, VALIDATOR_SIG)));
            }
        }
    }

    static final class ValueChangedExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        public ValueChangedExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression methodExpressionOneArg = this.attr.getMethodExpression(ctx, null, VALUECHANGE_SIG);
            MethodExpression methodExpressionZeroArg = this.attr.getMethodExpression(ctx, null, EMPTY_CLASS_ARRAY);
            if (FaceletCompositionContext.getCurrentInstance(ctx).isUsingPSSOnThisView()) {
                ((EditableValueHolder)instance).addValueChangeListener(new PartialMethodExpressionValueChangeListener(methodExpressionOneArg, methodExpressionZeroArg));
            } else {
                ((EditableValueHolder)instance).addValueChangeListener(new MethodExpressionValueChangeListener(methodExpressionOneArg, methodExpressionZeroArg));
            }
        }
    }
}

