/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.fileupload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.fileupload.FileItem;
import org.apache.myfaces.custom.fileupload.StorageStrategy;
import org.apache.myfaces.custom.fileupload.UploadedFileDefaultImplBase;

public class UploadedFileDefaultMemoryImpl
extends UploadedFileDefaultImplBase {
    private static final long serialVersionUID = -6006333070975059090L;
    private byte[] bytes;
    private StorageStrategy storageStrategy;
    private transient FileItem fileItem = null;

    public UploadedFileDefaultMemoryImpl(FileItem fileItem) throws IOException {
        super(fileItem.getName(), fileItem.getContentType());
        int sizeInBytes = (int)fileItem.getSize();
        this.bytes = new byte[sizeInBytes];
        this.fileItem = fileItem;
        fileItem.getInputStream().read(this.bytes);
        this.storageStrategy = new DefaultMemoryStorageStrategy();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    public long getSize() {
        if (this.bytes == null) {
            return 0L;
        }
        return this.bytes.length;
    }

    public StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    static /* synthetic */ byte[] access$202(UploadedFileDefaultMemoryImpl x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }

    private class DefaultMemoryStorageStrategy
    extends StorageStrategy
    implements Serializable {
        private static final long serialVersionUID = 3610866246514636068L;

        private DefaultMemoryStorageStrategy() {
        }

        public void deleteFileContents() {
            if (UploadedFileDefaultMemoryImpl.this.fileItem != null) {
                UploadedFileDefaultMemoryImpl.this.fileItem.delete();
            }
            UploadedFileDefaultMemoryImpl.access$202(UploadedFileDefaultMemoryImpl.this, null);
        }
    }
}

