/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler;

import javax.el.ValueExpression;
import javax.faces.FacesWrapper;

import org.apache.myfaces.commons.resourcehandler.resource.ResourceMeta;

/**
 * This class extends from ExtendedResourceMeta to allow cache request path expressions on
 * the resource cache and reuse it across requests.
 * 
 * @author Leonardo Uribe
 *
 */
public class ExtendedResourceMetaImpl extends ExtendedResourceMeta implements FacesWrapper<ResourceMeta>
{
    private ResourceMeta _delegate;
    private ValueExpression _requestPath;

    public ExtendedResourceMetaImpl(ResourceMeta delegate)
    {
        _delegate = delegate;
    }

    public ValueExpression getRequestPathExpression()
    {
        return _requestPath;
    }
    
    public void setRequestPathExpression(ValueExpression expression)
    {
        _requestPath = expression;
    }

    @Override
    public String getLibraryName()
    {
        return getWrapped().getLibraryName();
    }

    @Override
    public String getResourceName()
    {
        return getWrapped().getResourceName();
    }

    @Override
    public String getLocalePrefix()
    {
        return getWrapped().getLocalePrefix();
    }

    @Override
    public String getLibraryVersion()
    {
        return getWrapped().getLibraryVersion();
    }

    @Override
    public String getResourceVersion()
    {
        return getWrapped().getResourceVersion();
    }

    @Override
    public String getResourceIdentifier()
    {
        return getWrapped().getResourceIdentifier();
    }

    @Override
    public boolean couldResourceContainValueExpressions()
    {
        return getWrapped().couldResourceContainValueExpressions();
    }

    public ResourceMeta getWrapped()
    {
        return _delegate;
    }
}
