/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package javax.faces.component.html;

import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;


// Generated from class javax.faces.component.html._HtmlOutputFormat.
//
// WARNING: This file was automatically generated. Do not edit it directly,
//          or you will lose your changes.
public class HtmlOutputFormat extends javax.faces.component.UIOutput
{

    static public final String COMPONENT_TYPE =
        "javax.faces.HtmlOutputFormat";


    public HtmlOutputFormat()
    {
        setRendererType("javax.faces.Format");
    }

    

    // Property: style
    private String _style;
    public String getStyle()
    {
        if (_style != null)
        {
            return _style;
        }
        ValueBinding vb = getValueBinding("style");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setStyle(String style)
    {
        this._style = style;
    }
    // Property: styleClass
    private String _styleClass;
    public String getStyleClass()
    {
        if (_styleClass != null)
        {
            return _styleClass;
        }
        ValueBinding vb = getValueBinding("styleClass");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setStyleClass(String styleClass)
    {
        this._styleClass = styleClass;
    }
    // Property: title
    private String _title;
    public String getTitle()
    {
        if (_title != null)
        {
            return _title;
        }
        ValueBinding vb = getValueBinding("title");
        if (vb != null)
        {
            Object value = vb.getValue(getFacesContext());
            if (value == null)
            {
                return null;
            }
            else
            {
                return (String) value.toString();
            }
        }
        return null;
    }

    public void setTitle(String title)
    {
        this._title = title;
    }
    // Property: escape
    private boolean _escape;
    private boolean _escapeSet;
    
    public boolean isEscape()
    {
        if (_escapeSet)
        {
            return _escape;
        }
        ValueBinding vb = getValueBinding("escape");
        if (vb != null)
        {
            return ((Boolean) vb.getValue(getFacesContext())).booleanValue();
        }
        return true; 
    }

    public void setEscape(boolean escape)
    {
        this._escape = escape;
        this._escapeSet = true;        
    }

    public Object saveState(FacesContext facesContext)
    {
        Object[] values = new Object[6];
        values[0] = super.saveState(facesContext);
        values[1] = _style;
        values[2] = _styleClass;
        values[3] = _title;
        values[4] = Boolean.valueOf(_escape);
        values[5] = Boolean.valueOf(_escapeSet);
        return values; 
    }

    public void restoreState(FacesContext facesContext, Object state)
    {
        Object[] values = (Object[])state;
        super.restoreState(facesContext,values[0]);
        _style = (java.lang.String) values[1];
        _styleClass = (java.lang.String) values[2];
        _title = (java.lang.String) values[3];
        _escape = ((Boolean) values[4]).booleanValue();
        _escapeSet = ((Boolean) values[5]).booleanValue();
    }
}
