/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.java.hints.ui.ClassNameList;
import org.netbeans.modules.java.hints.ui.InnerPanelSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConstantNameOptions
extends JPanel {
    private boolean suppressEvents;
    private Preferences prefs;
    private Color defaultBkColor;
    private Color errorBkColor = new Color(255, 204, 153);
    private ClassNameList nameList;
    private JCheckBox immutableCheck;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSpinner maxLength;
    private JSpinner minLength;
    private JTextField namePattern;
    private JPanel typesHolder;

    public ConstantNameOptions(Preferences prefs) {
        this.initComponents();
        SpinnerNumberModel mdl1 = new SpinnerNumberModel(0, 0, 255, 1);
        SpinnerNumberModel mdl2 = new SpinnerNumberModel(0, 0, 255, 1);
        this.suppressEvents = true;
        this.minLength.setModel(mdl1);
        this.maxLength.setModel(mdl2);
        this.prefs = prefs;
        this.nameList = new ClassNameList();
        this.typesHolder.add(this.nameList);
        this.namePattern.setText(prefs.get("namePattern", "[A-Z]([A-Z\\d_]*[A-Z\\d])?"));
        this.minLength.setValue(prefs.getInt("minLength", 0));
        this.maxLength.setValue(prefs.getInt("maxLength", 35));
        this.immutableCheck.setSelected(prefs.getBoolean("onlyCheckImmutables", true));
        String types = prefs.get("immutableClasses", "");
        this.nameList.setClassNames(types);
        prefs.put("namePattern", this.namePattern.getText());
        prefs.putInt("minLength", (Integer)this.minLength.getValue());
        prefs.putInt("maxLength", (Integer)this.maxLength.getValue());
        prefs.putBoolean("onlyCheckImmutables", this.immutableCheck.isSelected());
        prefs.put("immutableClasses", types);
        this.suppressEvents = false;
        this.nameList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConstantNameOptions.this.saveClassNames();
            }
        });
        this.namePattern.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ConstantNameOptions.this.documentChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ConstantNameOptions.this.documentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        if (!this.immutableCheck.isSelected()) {
            InnerPanelSupport.enablePanel(this.typesHolder, false);
        }
    }

    private void saveClassNames() {
        if (this.suppressEvents) {
            return;
        }
        this.prefs.put("immutableClasses", this.nameList.getClassNameList());
    }

    private void documentChanged() {
        if (this.suppressEvents) {
            return;
        }
        String pat = this.namePattern.getText().trim();
        if (!"".equals(pat)) {
            try {
                Pattern pattern = Pattern.compile(pat);
            }
            catch (PatternSyntaxException ex) {
                this.namePattern.setBackground(this.errorBkColor);
                return;
            }
            this.namePattern.setBackground(this.defaultBkColor);
        }
        this.prefs.put("namePattern", pat);
    }

    private void initComponents() {
        this.immutableCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.namePattern = new JTextField();
        this.jLabel3 = new JLabel();
        this.minLength = new JSpinner();
        this.jLabel4 = new JLabel();
        this.maxLength = new JSpinner();
        this.typesHolder = new JPanel();
        Mnemonics.setLocalizedText(this.immutableCheck, NbBundle.getMessage(ConstantNameOptions.class, "ConstantNameOptions.immutableCheck.text"));
        this.immutableCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstantNameOptions.this.immutableCheckActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.jLabel1, NbBundle.getMessage(ConstantNameOptions.class, "ConstantNameOptions.jLabel1.text"));
        this.namePattern.setText(NbBundle.getMessage(ConstantNameOptions.class, "ConstantNameOptions.namePattern.text"));
        Mnemonics.setLocalizedText(this.jLabel3, NbBundle.getMessage(ConstantNameOptions.class, "ConstantNameOptions.jLabel3.text"));
        this.minLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConstantNameOptions.this.minLengthStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText(this.jLabel4, NbBundle.getMessage(ConstantNameOptions.class, "ConstantNameOptions.jLabel4.text"));
        this.maxLength.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConstantNameOptions.this.maxLengthStateChanged(evt);
            }
        });
        this.typesHolder.setLayout(new GridLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.typesHolder, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.namePattern).addGroup(layout.createSequentialGroup().addComponent(this.minLength, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addGap(6, 6, 6).addComponent(this.maxLength, -2, 48, -2).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.immutableCheck).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.namePattern, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.minLength, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.maxLength, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.immutableCheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typesHolder, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void immutableCheckActionPerformed(ActionEvent evt) {
        boolean enable = this.immutableCheck.isSelected();
        this.prefs.putBoolean("onlyCheckImmutables", enable);
        InnerPanelSupport.enablePanel(this.typesHolder, enable);
    }

    private void minLengthStateChanged(ChangeEvent evt) {
        if (this.suppressEvents) {
            return;
        }
        this.prefs.putInt("minLength", (Integer)this.minLength.getValue());
    }

    private void maxLengthStateChanged(ChangeEvent evt) {
        if (this.suppressEvents) {
            return;
        }
        this.prefs.putInt("maxLength", (Integer)this.maxLength.getValue());
    }
}

