/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.meta;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.Type;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.MetamodelImpl;

public class Types {
    protected static Localizer _loc = Localizer.forPackage(Types.class);

    public static class PseudoEntity<X>
    extends AbstractManagedType<X> {
        protected PseudoEntity(Class<X> cls, MetamodelImpl model) {
            super(cls, model);
        }

        @Override
        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.ENTITY;
        }
    }

    public static class Entity<X>
    extends Identifiable<X>
    implements EntityType<X> {
        public Entity(ClassMetaData meta, MetamodelImpl model) {
            super(meta, model);
        }

        @Override
        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.ENTITY;
        }

        @Override
        public String getName() {
            return this.meta.getTypeAlias();
        }

        @Override
        public Bindable.BindableType getBindableType() {
            return Bindable.BindableType.ENTITY_TYPE;
        }

        @Override
        public Class<X> getBindableJavaType() {
            return this.getJavaType();
        }
    }

    public static class MappedSuper<X>
    extends Identifiable<X>
    implements MappedSuperclassType<X> {
        public MappedSuper(ClassMetaData meta, MetamodelImpl model) {
            super(meta, model);
        }

        @Override
        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.MAPPED_SUPERCLASS;
        }
    }

    public static class Embeddable<X>
    extends AbstractManagedType<X>
    implements EmbeddableType<X> {
        public Embeddable(ClassMetaData meta, MetamodelImpl model) {
            super(meta, model);
        }

        @Override
        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.EMBEDDABLE;
        }
    }

    public static abstract class Identifiable<X>
    extends AbstractManagedType<X>
    implements IdentifiableType<X> {
        public Identifiable(ClassMetaData meta, MetamodelImpl model) {
            super(meta, model);
        }

        @Override
        public boolean hasVersionAttribute() {
            return this.meta.getVersionField() != null;
        }

        @Override
        public IdentifiableType<? super X> getSupertype() {
            ClassMetaData superMeta = this.meta.getPCSuperclassMetaData();
            if (superMeta == null) {
                return null;
            }
            return (IdentifiableType)this.model.managedType(superMeta.getDescribedType());
        }

        public boolean hasIdAttribute() {
            return this.meta.getIdentityType() == 2;
        }

        @Override
        public boolean hasSingleIdAttribute() {
            return this.meta.getPrimaryKeyFields().length == 1;
        }

        @Override
        public Type<?> getIdType() {
            Class idType = this.hasSingleIdAttribute() ? this.meta.getPrimaryKeyFields()[0].getDeclaredType() : this.meta.getObjectIdType();
            return this.model.getType(idType);
        }
    }

    public static class Basic<X>
    extends BaseType<X>
    implements Type<X> {
        public Basic(Class<X> cls) {
            super(cls);
        }

        @Override
        public Type.PersistenceType getPersistenceType() {
            return Type.PersistenceType.BASIC;
        }
    }

    static abstract class BaseType<X>
    implements Type<X> {
        public final Class<X> cls;

        protected BaseType(Class<X> cls) {
            this.cls = cls;
        }

        @Override
        public final Class<X> getJavaType() {
            return this.cls;
        }

        public String toString() {
            return this.cls.getName();
        }
    }
}

