/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataMemoryResponse is the corresponding interface of ApduDataMemoryResponse
type ApduDataMemoryResponse interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ApduData
	// GetAddress returns Address (property field)
	GetAddress() uint16
	// GetData returns Data (property field)
	GetData() []byte
	// IsApduDataMemoryResponse is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsApduDataMemoryResponse()
	// CreateBuilder creates a ApduDataMemoryResponseBuilder
	CreateApduDataMemoryResponseBuilder() ApduDataMemoryResponseBuilder
}

// _ApduDataMemoryResponse is the data-structure of this message
type _ApduDataMemoryResponse struct {
	ApduDataContract
	Address uint16
	Data    []byte
}

var _ ApduDataMemoryResponse = (*_ApduDataMemoryResponse)(nil)
var _ ApduDataRequirements = (*_ApduDataMemoryResponse)(nil)

// NewApduDataMemoryResponse factory function for _ApduDataMemoryResponse
func NewApduDataMemoryResponse(address uint16, data []byte, dataLength uint8) *_ApduDataMemoryResponse {
	_result := &_ApduDataMemoryResponse{
		ApduDataContract: NewApduData(dataLength),
		Address:          address,
		Data:             data,
	}
	_result.ApduDataContract.(*_ApduData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ApduDataMemoryResponseBuilder is a builder for ApduDataMemoryResponse
type ApduDataMemoryResponseBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(address uint16, data []byte) ApduDataMemoryResponseBuilder
	// WithAddress adds Address (property field)
	WithAddress(uint16) ApduDataMemoryResponseBuilder
	// WithData adds Data (property field)
	WithData(...byte) ApduDataMemoryResponseBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ApduDataBuilder
	// Build builds the ApduDataMemoryResponse or returns an error if something is wrong
	Build() (ApduDataMemoryResponse, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ApduDataMemoryResponse
}

// NewApduDataMemoryResponseBuilder() creates a ApduDataMemoryResponseBuilder
func NewApduDataMemoryResponseBuilder() ApduDataMemoryResponseBuilder {
	return &_ApduDataMemoryResponseBuilder{_ApduDataMemoryResponse: new(_ApduDataMemoryResponse)}
}

type _ApduDataMemoryResponseBuilder struct {
	*_ApduDataMemoryResponse

	parentBuilder *_ApduDataBuilder

	collectedErr []error
}

var _ (ApduDataMemoryResponseBuilder) = (*_ApduDataMemoryResponseBuilder)(nil)

func (b *_ApduDataMemoryResponseBuilder) setParent(contract ApduDataContract) {
	b.ApduDataContract = contract
	contract.(*_ApduData)._SubType = b._ApduDataMemoryResponse
}

func (b *_ApduDataMemoryResponseBuilder) WithMandatoryFields(address uint16, data []byte) ApduDataMemoryResponseBuilder {
	return b.WithAddress(address).WithData(data...)
}

func (b *_ApduDataMemoryResponseBuilder) WithAddress(address uint16) ApduDataMemoryResponseBuilder {
	b.Address = address
	return b
}

func (b *_ApduDataMemoryResponseBuilder) WithData(data ...byte) ApduDataMemoryResponseBuilder {
	b.Data = data
	return b
}

func (b *_ApduDataMemoryResponseBuilder) Build() (ApduDataMemoryResponse, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ApduDataMemoryResponse.deepCopy(), nil
}

func (b *_ApduDataMemoryResponseBuilder) MustBuild() ApduDataMemoryResponse {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ApduDataMemoryResponseBuilder) Done() ApduDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewApduDataBuilder().(*_ApduDataBuilder)
	}
	return b.parentBuilder
}

func (b *_ApduDataMemoryResponseBuilder) buildForApduData() (ApduData, error) {
	return b.Build()
}

func (b *_ApduDataMemoryResponseBuilder) DeepCopy() any {
	_copy := b.CreateApduDataMemoryResponseBuilder().(*_ApduDataMemoryResponseBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateApduDataMemoryResponseBuilder creates a ApduDataMemoryResponseBuilder
func (b *_ApduDataMemoryResponse) CreateApduDataMemoryResponseBuilder() ApduDataMemoryResponseBuilder {
	if b == nil {
		return NewApduDataMemoryResponseBuilder()
	}
	return &_ApduDataMemoryResponseBuilder{_ApduDataMemoryResponse: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataMemoryResponse) GetApciType() uint8 {
	return 0x9
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataMemoryResponse) GetParent() ApduDataContract {
	return m.ApduDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ApduDataMemoryResponse) GetAddress() uint16 {
	return m.Address
}

func (m *_ApduDataMemoryResponse) GetData() []byte {
	return m.Data
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastApduDataMemoryResponse(structType any) ApduDataMemoryResponse {
	if casted, ok := structType.(ApduDataMemoryResponse); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataMemoryResponse); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataMemoryResponse) GetTypeName() string {
	return "ApduDataMemoryResponse"
}

func (m *_ApduDataMemoryResponse) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ApduDataContract.(*_ApduData).getLengthInBits(ctx))

	// Implicit Field (numBytes)
	lengthInBits += 6

	// Simple field (address)
	lengthInBits += 16

	// Array field
	if len(m.Data) > 0 {
		lengthInBits += 8 * uint16(len(m.Data))
	}

	return lengthInBits
}

func (m *_ApduDataMemoryResponse) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ApduDataMemoryResponse) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ApduData, dataLength uint8) (__apduDataMemoryResponse ApduDataMemoryResponse, err error) {
	m.ApduDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataMemoryResponse"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataMemoryResponse")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	numBytes, err := ReadImplicitField[uint8](ctx, "numBytes", ReadUnsignedByte(readBuffer, uint8(6)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'numBytes' field"))
	}
	_ = numBytes

	address, err := ReadSimpleField(ctx, "address", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'address' field"))
	}
	m.Address = address

	data, err := readBuffer.ReadByteArray("data", int(numBytes))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'data' field"))
	}
	m.Data = data

	if closeErr := readBuffer.CloseContext("ApduDataMemoryResponse"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataMemoryResponse")
	}

	return m, nil
}

func (m *_ApduDataMemoryResponse) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ApduDataMemoryResponse) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataMemoryResponse"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataMemoryResponse")
		}
		numBytes := uint8(uint8(len(m.GetData())))
		if err := WriteImplicitField(ctx, "numBytes", numBytes, WriteUnsignedByte(writeBuffer, 6)); err != nil {
			return errors.Wrap(err, "Error serializing 'numBytes' field")
		}

		if err := WriteSimpleField[uint16](ctx, "address", m.GetAddress(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'address' field")
		}

		if err := WriteByteArrayField(ctx, "data", m.GetData(), WriteByteArray(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'data' field")
		}

		if popErr := writeBuffer.PopContext("ApduDataMemoryResponse"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataMemoryResponse")
		}
		return nil
	}
	return m.ApduDataContract.(*_ApduData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ApduDataMemoryResponse) IsApduDataMemoryResponse() {}

func (m *_ApduDataMemoryResponse) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ApduDataMemoryResponse) deepCopy() *_ApduDataMemoryResponse {
	if m == nil {
		return nil
	}
	_ApduDataMemoryResponseCopy := &_ApduDataMemoryResponse{
		m.ApduDataContract.(*_ApduData).deepCopy(),
		m.Address,
		utils.DeepCopySlice[byte, byte](m.Data),
	}
	_ApduDataMemoryResponseCopy.ApduDataContract.(*_ApduData)._SubType = m
	return _ApduDataMemoryResponseCopy
}

func (m *_ApduDataMemoryResponse) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
