/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// KnxGroupAddressFreeLevel is the corresponding interface of KnxGroupAddressFreeLevel
type KnxGroupAddressFreeLevel interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	KnxGroupAddress
	// GetSubGroup returns SubGroup (property field)
	GetSubGroup() uint16
	// IsKnxGroupAddressFreeLevel is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsKnxGroupAddressFreeLevel()
	// CreateBuilder creates a KnxGroupAddressFreeLevelBuilder
	CreateKnxGroupAddressFreeLevelBuilder() KnxGroupAddressFreeLevelBuilder
}

// _KnxGroupAddressFreeLevel is the data-structure of this message
type _KnxGroupAddressFreeLevel struct {
	KnxGroupAddressContract
	SubGroup uint16
}

var _ KnxGroupAddressFreeLevel = (*_KnxGroupAddressFreeLevel)(nil)
var _ KnxGroupAddressRequirements = (*_KnxGroupAddressFreeLevel)(nil)

// NewKnxGroupAddressFreeLevel factory function for _KnxGroupAddressFreeLevel
func NewKnxGroupAddressFreeLevel(subGroup uint16) *_KnxGroupAddressFreeLevel {
	_result := &_KnxGroupAddressFreeLevel{
		KnxGroupAddressContract: NewKnxGroupAddress(),
		SubGroup:                subGroup,
	}
	_result.KnxGroupAddressContract.(*_KnxGroupAddress)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// KnxGroupAddressFreeLevelBuilder is a builder for KnxGroupAddressFreeLevel
type KnxGroupAddressFreeLevelBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(subGroup uint16) KnxGroupAddressFreeLevelBuilder
	// WithSubGroup adds SubGroup (property field)
	WithSubGroup(uint16) KnxGroupAddressFreeLevelBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() KnxGroupAddressBuilder
	// Build builds the KnxGroupAddressFreeLevel or returns an error if something is wrong
	Build() (KnxGroupAddressFreeLevel, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() KnxGroupAddressFreeLevel
}

// NewKnxGroupAddressFreeLevelBuilder() creates a KnxGroupAddressFreeLevelBuilder
func NewKnxGroupAddressFreeLevelBuilder() KnxGroupAddressFreeLevelBuilder {
	return &_KnxGroupAddressFreeLevelBuilder{_KnxGroupAddressFreeLevel: new(_KnxGroupAddressFreeLevel)}
}

type _KnxGroupAddressFreeLevelBuilder struct {
	*_KnxGroupAddressFreeLevel

	parentBuilder *_KnxGroupAddressBuilder

	collectedErr []error
}

var _ (KnxGroupAddressFreeLevelBuilder) = (*_KnxGroupAddressFreeLevelBuilder)(nil)

func (b *_KnxGroupAddressFreeLevelBuilder) setParent(contract KnxGroupAddressContract) {
	b.KnxGroupAddressContract = contract
	contract.(*_KnxGroupAddress)._SubType = b._KnxGroupAddressFreeLevel
}

func (b *_KnxGroupAddressFreeLevelBuilder) WithMandatoryFields(subGroup uint16) KnxGroupAddressFreeLevelBuilder {
	return b.WithSubGroup(subGroup)
}

func (b *_KnxGroupAddressFreeLevelBuilder) WithSubGroup(subGroup uint16) KnxGroupAddressFreeLevelBuilder {
	b.SubGroup = subGroup
	return b
}

func (b *_KnxGroupAddressFreeLevelBuilder) Build() (KnxGroupAddressFreeLevel, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._KnxGroupAddressFreeLevel.deepCopy(), nil
}

func (b *_KnxGroupAddressFreeLevelBuilder) MustBuild() KnxGroupAddressFreeLevel {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_KnxGroupAddressFreeLevelBuilder) Done() KnxGroupAddressBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewKnxGroupAddressBuilder().(*_KnxGroupAddressBuilder)
	}
	return b.parentBuilder
}

func (b *_KnxGroupAddressFreeLevelBuilder) buildForKnxGroupAddress() (KnxGroupAddress, error) {
	return b.Build()
}

func (b *_KnxGroupAddressFreeLevelBuilder) DeepCopy() any {
	_copy := b.CreateKnxGroupAddressFreeLevelBuilder().(*_KnxGroupAddressFreeLevelBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateKnxGroupAddressFreeLevelBuilder creates a KnxGroupAddressFreeLevelBuilder
func (b *_KnxGroupAddressFreeLevel) CreateKnxGroupAddressFreeLevelBuilder() KnxGroupAddressFreeLevelBuilder {
	if b == nil {
		return NewKnxGroupAddressFreeLevelBuilder()
	}
	return &_KnxGroupAddressFreeLevelBuilder{_KnxGroupAddressFreeLevel: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_KnxGroupAddressFreeLevel) GetNumLevels() uint8 {
	return uint8(1)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_KnxGroupAddressFreeLevel) GetParent() KnxGroupAddressContract {
	return m.KnxGroupAddressContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_KnxGroupAddressFreeLevel) GetSubGroup() uint16 {
	return m.SubGroup
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastKnxGroupAddressFreeLevel(structType any) KnxGroupAddressFreeLevel {
	if casted, ok := structType.(KnxGroupAddressFreeLevel); ok {
		return casted
	}
	if casted, ok := structType.(*KnxGroupAddressFreeLevel); ok {
		return *casted
	}
	return nil
}

func (m *_KnxGroupAddressFreeLevel) GetTypeName() string {
	return "KnxGroupAddressFreeLevel"
}

func (m *_KnxGroupAddressFreeLevel) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.KnxGroupAddressContract.(*_KnxGroupAddress).getLengthInBits(ctx))

	// Simple field (subGroup)
	lengthInBits += 16

	return lengthInBits
}

func (m *_KnxGroupAddressFreeLevel) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_KnxGroupAddressFreeLevel) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_KnxGroupAddress, numLevels uint8) (__knxGroupAddressFreeLevel KnxGroupAddressFreeLevel, err error) {
	m.KnxGroupAddressContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("KnxGroupAddressFreeLevel"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for KnxGroupAddressFreeLevel")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	subGroup, err := ReadSimpleField(ctx, "subGroup", ReadUnsignedShort(readBuffer, uint8(16)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'subGroup' field"))
	}
	m.SubGroup = subGroup

	if closeErr := readBuffer.CloseContext("KnxGroupAddressFreeLevel"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for KnxGroupAddressFreeLevel")
	}

	return m, nil
}

func (m *_KnxGroupAddressFreeLevel) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_KnxGroupAddressFreeLevel) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("KnxGroupAddressFreeLevel"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for KnxGroupAddressFreeLevel")
		}

		if err := WriteSimpleField[uint16](ctx, "subGroup", m.GetSubGroup(), WriteUnsignedShort(writeBuffer, 16)); err != nil {
			return errors.Wrap(err, "Error serializing 'subGroup' field")
		}

		if popErr := writeBuffer.PopContext("KnxGroupAddressFreeLevel"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for KnxGroupAddressFreeLevel")
		}
		return nil
	}
	return m.KnxGroupAddressContract.(*_KnxGroupAddress).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_KnxGroupAddressFreeLevel) IsKnxGroupAddressFreeLevel() {}

func (m *_KnxGroupAddressFreeLevel) DeepCopy() any {
	return m.deepCopy()
}

func (m *_KnxGroupAddressFreeLevel) deepCopy() *_KnxGroupAddressFreeLevel {
	if m == nil {
		return nil
	}
	_KnxGroupAddressFreeLevelCopy := &_KnxGroupAddressFreeLevel{
		m.KnxGroupAddressContract.(*_KnxGroupAddress).deepCopy(),
		m.SubGroup,
	}
	_KnxGroupAddressFreeLevelCopy.KnxGroupAddressContract.(*_KnxGroupAddress)._SubType = m
	return _KnxGroupAddressFreeLevelCopy
}

func (m *_KnxGroupAddressFreeLevel) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
