/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetApplicationTagEnumerated extends BACnetApplicationTag implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetTagPayloadEnumerated payload;

  public BACnetApplicationTagEnumerated(
      BACnetTagHeader header, BACnetTagPayloadEnumerated payload) {
    super(header);
    this.payload = payload;
  }

  public BACnetTagPayloadEnumerated getPayload() {
    return payload;
  }

  public long getActualValue() {
    return (long) (getPayload().getActualValue());
  }

  @Override
  protected void serializeBACnetApplicationTagChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetApplicationTagEnumerated");

    // Simple Field (payload)
    writeSimpleField("payload", payload, writeComplex(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    long actualValue = getActualValue();
    writeBuffer.writeVirtual("actualValue", actualValue);

    writeBuffer.popContext("BACnetApplicationTagEnumerated");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetApplicationTagEnumerated _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (payload)
    lengthInBits += payload.getLengthInBits();

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static BACnetApplicationTagBuilder staticParseBACnetApplicationTagBuilder(
      ReadBuffer readBuffer, BACnetTagHeader header) throws ParseException {
    readBuffer.pullContext("BACnetApplicationTagEnumerated");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetTagPayloadEnumerated payload =
        readSimpleField(
            "payload",
            readComplex(
                () ->
                    BACnetTagPayloadEnumerated.staticParse(
                        readBuffer, (long) (header.getActualLength())),
                readBuffer));
    long actualValue = readVirtualField("actualValue", long.class, payload.getActualValue());

    readBuffer.closeContext("BACnetApplicationTagEnumerated");
    // Create the instance
    return new BACnetApplicationTagEnumeratedBuilderImpl(payload);
  }

  public static class BACnetApplicationTagEnumeratedBuilderImpl
      implements BACnetApplicationTag.BACnetApplicationTagBuilder {
    private final BACnetTagPayloadEnumerated payload;

    public BACnetApplicationTagEnumeratedBuilderImpl(BACnetTagPayloadEnumerated payload) {
      this.payload = payload;
    }

    public BACnetApplicationTagEnumerated build(BACnetTagHeader header) {
      BACnetApplicationTagEnumerated bACnetApplicationTagEnumerated =
          new BACnetApplicationTagEnumerated(header, payload);
      return bACnetApplicationTagEnumerated;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetApplicationTagEnumerated)) {
      return false;
    }
    BACnetApplicationTagEnumerated that = (BACnetApplicationTagEnumerated) o;
    return (getPayload() == that.getPayload()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getPayload());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
