/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class MediaTransportControlDataShuffleOnOff extends MediaTransportControlData
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte state;

  public MediaTransportControlDataShuffleOnOff(
      MediaTransportControlCommandTypeContainer commandTypeContainer,
      byte mediaLinkGroup,
      byte state) {
    super(commandTypeContainer, mediaLinkGroup);
    this.state = state;
  }

  public byte getState() {
    return state;
  }

  public boolean getIsOff() {
    return (boolean) ((getState()) == (0x00));
  }

  public boolean getIsOn() {
    return (boolean) ((getState()) > (0xFE));
  }

  @Override
  protected void serializeMediaTransportControlDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("MediaTransportControlDataShuffleOnOff");

    // Simple Field (state)
    writeSimpleField("state", state, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isOff = getIsOff();
    writeBuffer.writeVirtual("isOff", isOff);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isOn = getIsOn();
    writeBuffer.writeVirtual("isOn", isOn);

    writeBuffer.popContext("MediaTransportControlDataShuffleOnOff");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    MediaTransportControlDataShuffleOnOff _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (state)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static MediaTransportControlDataBuilder staticParseMediaTransportControlDataBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("MediaTransportControlDataShuffleOnOff");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte state = readSimpleField("state", readByte(readBuffer, 8));
    boolean isOff = readVirtualField("isOff", boolean.class, (state) == (0x00));
    boolean isOn = readVirtualField("isOn", boolean.class, (state) > (0xFE));

    readBuffer.closeContext("MediaTransportControlDataShuffleOnOff");
    // Create the instance
    return new MediaTransportControlDataShuffleOnOffBuilderImpl(state);
  }

  public static class MediaTransportControlDataShuffleOnOffBuilderImpl
      implements MediaTransportControlData.MediaTransportControlDataBuilder {
    private final byte state;

    public MediaTransportControlDataShuffleOnOffBuilderImpl(byte state) {
      this.state = state;
    }

    public MediaTransportControlDataShuffleOnOff build(
        MediaTransportControlCommandTypeContainer commandTypeContainer, byte mediaLinkGroup) {
      MediaTransportControlDataShuffleOnOff mediaTransportControlDataShuffleOnOff =
          new MediaTransportControlDataShuffleOnOff(commandTypeContainer, mediaLinkGroup, state);
      return mediaTransportControlDataShuffleOnOff;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof MediaTransportControlDataShuffleOnOff)) {
      return false;
    }
    MediaTransportControlDataShuffleOnOff that = (MediaTransportControlDataShuffleOnOff) o;
    return (getState() == that.getState()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getState());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
