/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum CIPStatus {
  Success((long) 0x00000000L),
  ConnectionFailure((long) 0x00000001L),
  ResourceUnAvailable((long) 0x00000002L),
  InvalidParameterValue((long) 0x00000003L),
  PathSegmentError((long) 0x00000004L),
  PathDestinationUnknown((long) 0x00000005L),
  PartialTransfer((long) 0x00000006L),
  ConnectionIDNotValid((long) 0x00000007L),
  ServiceNotSupported((long) 0x00000008L),
  InvalidAttributeValue((long) 0x00000009L),
  AttributeListError((long) 0x0000000AL),
  AlreadyInRequestedState((long) 0x0000000BL),
  ObjectStateConflict((long) 0x0000000CL),
  ObjectAlreadyExists((long) 0x0000000DL),
  AttributeNotSettable((long) 0x0000000EL),
  PrivilegeViolation((long) 0x0000000FL),
  DeviceStateConflict((long) 0x00000010L),
  ReplyDataTooLarge((long) 0x00000011L),
  FragmentationOfPrimitiveValue((long) 0x00000012L),
  NotEnoughData((long) 0x00000013L),
  AttributeNotSupported((long) 0x00000014L),
  TooMuchData((long) 0x00000015L),
  ObjectDoesNotExist((long) 0x00000016L),
  ServiceFragmentation((long) 0x00000017L),
  NoStoredAttributeData((long) 0x00000018L),
  StoreOperationFailure((long) 0x00000019L),
  RequestPacketTooLarge((long) 0x0000001AL),
  ResponsePacketTooLarge((long) 0x0000001BL),
  MissingAttributeListEntryData((long) 0x0000001CL),
  InvalidAttributeValueList((long) 0x0000001DL),
  EmbeddedServiceError((long) 0x0000001EL),
  VendorSpecificError((long) 0x0000001FL),
  InvalidCommandWithWrongEndianess((long) 0x01000000L);
  private static final Map<Long, CIPStatus> map;

  static {
    map = new HashMap<>();
    for (CIPStatus value : CIPStatus.values()) {
      map.put((long) value.getValue(), value);
    }
  }

  private final long value;

  CIPStatus(long value) {
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  public static CIPStatus enumForValue(long value) {
    return map.get(value);
  }

  public static Boolean isDefined(long value) {
    return map.containsKey(value);
  }
}
