/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class InformationObjectWithTreeByteTime extends InformationObject
    implements Message {

  // Accessors for discriminator values.
  public Byte getNumTimeByte() {
    return (byte) 3;
  }

  // Abstract accessors for discriminator values.
  public abstract TypeIdentification getTypeIdentification();

  public InformationObjectWithTreeByteTime(int address) {
    super(address);
  }

  public abstract ThreeOctetBinaryTime getCp24Time2a();

  protected abstract void serializeInformationObjectWithTreeByteTimeChild(WriteBuffer writeBuffer)
      throws SerializationException;

  @Override
  protected void serializeInformationObjectChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithTreeByteTime");

    // Switch field (Serialize the sub-type)
    serializeInformationObjectWithTreeByteTimeChild(writeBuffer);

    writeBuffer.popContext("InformationObjectWithTreeByteTime");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithTreeByteTime _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static InformationObjectBuilder staticParseInformationObjectBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithTreeByteTime");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    InformationObjectWithTreeByteTimeBuilder builder = null;
    if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.SINGLE_POINT_INFORMATION_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_SINGLE_POINT_INFORMATION
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.DOUBLE_POINT_INFORMATION_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_DOUBLE_POINT_INFORMATION
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.STEP_POSITION_INFORMATION_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_STEP_POSITION_INFORMATION
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.BITSTRING_OF_32_BIT_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_BITSTRING_OF_32_BIT
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.MEASURED_VALUE_NORMALIZED_VALUE_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_MEASURED_VALUE_NORMALIZED_VALUE
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.MEASURED_VALUE_SCALED_VALUE_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_MEASURED_VALUE_SCALED_VALUE
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification,
        TypeIdentification.MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_MEASURED_VALUE_SHORT_FLOATING_POINT_NUMBER
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.INTEGRATED_TOTALS_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_INTEGRATED_TOTALS
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification, TypeIdentification.EVENT_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_EVENT_OF_PROTECTION_EQUIPMENT
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification,
        TypeIdentification.PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_PACKED_START_EVENTS_OF_PROTECTION_EQUIPMENT
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    } else if (EvaluationHelper.equals(
        typeIdentification,
        TypeIdentification
            .PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT_WITH_TIME_TAG)) {
      builder =
          InformationObjectWithTreeByteTime_PACKED_OUTPUT_CIRCUIT_INFORMATION_OF_PROTECTION_EQUIPMENT
              .staticParseInformationObjectWithTreeByteTimeBuilder(
                  readBuffer, typeIdentification, numTimeByte);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "typeIdentification="
              + typeIdentification
              + "]");
    }

    readBuffer.closeContext("InformationObjectWithTreeByteTime");
    // Create the instance
    return new InformationObjectWithTreeByteTimeBuilderImpl(builder);
  }

  public interface InformationObjectWithTreeByteTimeBuilder {
    InformationObjectWithTreeByteTime build(int address);
  }

  public static class InformationObjectWithTreeByteTimeBuilderImpl
      implements InformationObject.InformationObjectBuilder {
    private final InformationObjectWithTreeByteTimeBuilder builder;

    public InformationObjectWithTreeByteTimeBuilderImpl(
        InformationObjectWithTreeByteTimeBuilder builder) {
      this.builder = builder;
    }

    public InformationObjectWithTreeByteTime build(int address) {
      return builder.build(address);
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithTreeByteTime)) {
      return false;
    }
    InformationObjectWithTreeByteTime that = (InformationObjectWithTreeByteTime) o;
    return super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
