/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.utils.install;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlConfigChanger {
    private static final String EMPTY_TOKEN = "%EMPTY%";
    private static final String EMPTY_TOKEN_VALUE = "";
    public static final String ROOT_NODE_NAME = "configuration";
    public static final String NAME_NODE_NAME = "name";
    public static final String PROPERTY_NODE_NAME = "property";
    public static final String VALUE_NODE_NAME = "value";
    private File inpFile;
    private File outFile;
    private File confFile;
    private File propFile;
    private Document doc;
    Properties installProperties = new Properties();

    public static void main(String[] args) {
        XmlConfigChanger xmlConfigChanger = new XmlConfigChanger();
        xmlConfigChanger.parseConfig(args);
        try {
            xmlConfigChanger.run();
        }
        catch (Throwable t) {
            System.err.println("*************************************************************************");
            System.err.println("******* ERROR: unable to process xml configuration changes due to error:" + t.getMessage());
            t.printStackTrace();
            System.err.println("*************************************************************************");
            System.exit(1);
        }
    }

    public void parseConfig(String[] args) {
        String installPropFileName;
        Options options = new Options();
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"input");
        OptionBuilder.withDescription((String)"Input xml file name");
        Option inputOption = OptionBuilder.create((char)'i');
        options.addOption(inputOption);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"Output xml file name");
        Option outputOption = OptionBuilder.create((char)'o');
        options.addOption(outputOption);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Config file name");
        Option configOption = OptionBuilder.create((char)'c');
        options.addOption(configOption);
        OptionBuilder.hasArgs((int)1);
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withLongOpt((String)"installprop");
        OptionBuilder.withDescription((String)"install.properties");
        Option installPropOption = OptionBuilder.create((char)'p');
        options.addOption(installPropOption);
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            String header = "ERROR: " + (Object)((Object)e);
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java " + XmlConfigChanger.class.getName(), header, options, null, true);
            throw new RuntimeException(e);
        }
        String inputFileName = cmd.getOptionValue('i');
        this.inpFile = new File(inputFileName);
        if (!this.inpFile.canRead()) {
            String header = "ERROR: Input file [" + this.inpFile.getAbsolutePath() + "] can not be read.";
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java " + XmlConfigChanger.class.getName(), header, options, null, true);
            throw new RuntimeException(header);
        }
        String outputFileName = cmd.getOptionValue('o');
        this.outFile = new File(outputFileName);
        if (this.outFile.exists()) {
            String header = "ERROR: Output file [" + this.outFile.getAbsolutePath() + "] already exists. Specify a filepath for creating new output file for the input [" + this.inpFile.getAbsolutePath() + "]";
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java " + XmlConfigChanger.class.getName(), header, options, null, true);
            throw new RuntimeException(header);
        }
        String configFileName = cmd.getOptionValue('c');
        this.confFile = new File(configFileName);
        if (!this.confFile.canRead()) {
            String header = "ERROR: Config file [" + this.confFile.getAbsolutePath() + "] can not be read.";
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java " + XmlConfigChanger.class.getName(), header, options, null, true);
            throw new RuntimeException(header);
        }
        String string = installPropFileName = cmd.hasOption('p') ? cmd.getOptionValue('p') : null;
        if (installPropFileName != null) {
            this.propFile = new File(installPropFileName);
            if (!this.propFile.canRead()) {
                String header = "ERROR: Install Property file [" + this.propFile.getAbsolutePath() + "] can not be read.";
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java " + XmlConfigChanger.class.getName(), header, options, null, true);
                throw new RuntimeException(header);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this.loadInstallProperties();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.parse(this.inpFile);
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(this.confFile));
            String line = null;
            int lineNo = 0;
            Properties variables = new Properties();
            while ((line = reader.readLine()) != null) {
                String appendDelimitor;
                String curVal;
                boolean createIfNotExists;
                ++lineNo;
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.contains("#")) {
                    int len = line.indexOf("#");
                    line = line.substring(0, len);
                }
                String[] tokens = line.split("\\s+");
                String propName = tokens[0];
                String propValue = null;
                try {
                    if (this.propnameContainsVariables(propName)) {
                        propName = this.replaceProp(propName, variables);
                    }
                    propValue = this.replaceProp(tokens[1], this.installProperties);
                }
                catch (ValidationException e) {
                    throw new RuntimeException(e);
                }
                String actionType = tokens[2];
                String options = tokens.length > 3 ? tokens[3] : null;
                boolean bl = createIfNotExists = options != null && options.contains("create-if-not-exists");
                if ("add".equals(actionType)) {
                    this.addProperty(propName, propValue);
                    continue;
                }
                if ("mod".equals(actionType)) {
                    this.modProperty(propName, propValue, createIfNotExists);
                    continue;
                }
                if ("del".equals(actionType)) {
                    this.delProperty(propName);
                    continue;
                }
                if ("append".equals(actionType)) {
                    curVal = this.getProperty(propName);
                    if (curVal == null) {
                        if (!createIfNotExists) continue;
                        this.addProperty(propName, propValue);
                        continue;
                    }
                    String string = appendDelimitor = tokens.length > 4 ? tokens[4] : " ";
                    if (curVal.contains(propValue)) continue;
                    String newVal = null;
                    newVal = curVal.length() == 0 ? propValue : curVal + appendDelimitor + propValue;
                    this.modProperty(propName, newVal, createIfNotExists);
                    continue;
                }
                if ("delval".equals(actionType)) {
                    curVal = this.getProperty(propName);
                    if (curVal == null) continue;
                    String string = appendDelimitor = tokens.length > 4 ? tokens[4] : " ";
                    if (!curVal.contains(propValue)) continue;
                    String[] valTokens = curVal.split(appendDelimitor);
                    StringBuilder sb = new StringBuilder();
                    for (String v : valTokens) {
                        if (v.equals(propValue)) continue;
                        if (sb.length() > 0) {
                            sb.append(appendDelimitor);
                        }
                        sb.append(v);
                    }
                    String newVal = sb.toString();
                    this.modProperty(propName, newVal, createIfNotExists);
                    continue;
                }
                if ("var".equals(actionType)) {
                    variables.put(propName, propValue);
                    continue;
                }
                throw new RuntimeException("Unknown Command Found: [" + actionType + "], Supported Types:  add modify del append");
            }
            TransformerFactory tfactory = TransformerFactory.newInstance();
            tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", EMPTY_TOKEN_VALUE);
            tfactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", EMPTY_TOKEN_VALUE);
            tfactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(this.doc);
            FileOutputStream out = new FileOutputStream(this.outFile);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
            out.close();
        }
    }

    private boolean propnameContainsVariables(String propName) {
        int second;
        int first;
        return propName != null && (first = propName.indexOf(37)) != -1 && (second = propName.indexOf(37, first + 1)) != -1;
    }

    private void addProperty(String propName, String val) {
        NodeList nl = this.doc.getElementsByTagName(ROOT_NODE_NAME);
        Node rootConfig = nl.item(0);
        rootConfig.appendChild(this.createNewElement(propName, val));
    }

    private void modProperty(String propName, String val, boolean createIfNotExists) {
        Node node = this.findProperty(propName);
        if (node != null) {
            NodeList cnl = node.getChildNodes();
            for (int j = 0; j < cnl.getLength(); ++j) {
                String nodeName = cnl.item(j).getNodeName();
                if (!nodeName.equals(VALUE_NODE_NAME)) continue;
                if (cnl.item(j).hasChildNodes()) {
                    cnl.item(j).getChildNodes().item(0).setNodeValue(val);
                } else {
                    Node propValueNode = cnl.item(j);
                    Text txtNode = this.doc.createTextNode(val);
                    propValueNode.appendChild(txtNode);
                    txtNode.setNodeValue(val);
                }
                return;
            }
        }
        if (createIfNotExists) {
            this.addProperty(propName, val);
        }
    }

    private String getProperty(String propName) {
        String ret;
        block4: {
            ret = null;
            try {
                Node node = this.findProperty(propName);
                if (node == null) break block4;
                NodeList cnl = node.getChildNodes();
                for (int j = 0; j < cnl.getLength(); ++j) {
                    String nodeName = cnl.item(j).getNodeName();
                    if (!nodeName.equals(VALUE_NODE_NAME)) continue;
                    Node valueNode = null;
                    if (cnl.item(j).hasChildNodes()) {
                        valueNode = cnl.item(j).getChildNodes().item(0);
                    }
                    ret = valueNode == null ? EMPTY_TOKEN_VALUE : valueNode.getNodeValue();
                    break;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("getProperty(" + propName + ") failed.", t);
            }
        }
        return ret;
    }

    private void delProperty(String propName) {
        Node node = this.findProperty(propName);
        if (node != null) {
            node.getParentNode().removeChild(node);
        }
    }

    private Node findProperty(String propName) {
        Node ret = null;
        try {
            NodeList nl = this.doc.getElementsByTagName(PROPERTY_NODE_NAME);
            for (int i = 0; i < nl.getLength(); ++i) {
                String pName;
                String nodeName;
                NodeList cnl = nl.item(i).getChildNodes();
                boolean found = false;
                for (int j = 0; !(j >= cnl.getLength() || (nodeName = cnl.item(j).getNodeName()).equals(NAME_NODE_NAME) && (found = (pName = cnl.item(j).getChildNodes().item(0).getNodeValue()).equals(propName))); ++j) {
                }
                if (!found) continue;
                ret = nl.item(i);
                break;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("findProperty(" + propName + ") failed.", t);
        }
        return ret;
    }

    private Element createNewElement(String propName, String val) {
        Element ret = null;
        try {
            if (this.doc != null) {
                ret = this.doc.createElement(PROPERTY_NODE_NAME);
                Element propNameNode = this.doc.createElement(NAME_NODE_NAME);
                Text txtNode = this.doc.createTextNode(propName);
                propNameNode.appendChild(txtNode);
                propNameNode.setNodeValue(propName);
                ret.appendChild(propNameNode);
                Element propValueNode = this.doc.createElement(VALUE_NODE_NAME);
                txtNode = this.doc.createTextNode(val);
                propValueNode.appendChild(txtNode);
                propValueNode.setNodeValue(propName);
                ret.appendChild(propValueNode);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("createNewElement(" + propName + ") with value [" + val + "] failed.", t);
        }
        return ret;
    }

    private void loadInstallProperties() {
        if (this.propFile != null) {
            try (FileInputStream in = new FileInputStream(this.propFile);){
                this.installProperties.load(in);
            }
            catch (IOException ioe) {
                System.err.println("******* ERROR: load file failure. The reason: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        this.installProperties.putAll(System.getenv());
    }

    private String replaceProp(String propValue, Properties prop) throws ValidationException {
        StringBuilder tokensb = new StringBuilder();
        StringBuilder retsb = new StringBuilder();
        boolean isToken = false;
        for (char c : propValue.toCharArray()) {
            if (c == '%') {
                if (isToken) {
                    String tokenValue;
                    String token = tokensb.toString();
                    String string = tokenValue = token.length() == 0 ? "%" : prop.getProperty(token);
                    if (tokenValue == null || tokenValue.trim().isEmpty()) {
                        throw new ValidationException("ERROR: configuration token [" + token + "] is not defined in the file: [" + (this.propFile != null ? this.propFile.getAbsolutePath() : "{no install.properties file specified using -p option}") + "]");
                    }
                    if (EMPTY_TOKEN.equals(tokenValue)) {
                        retsb.append(EMPTY_TOKEN_VALUE);
                    } else {
                        retsb.append(tokenValue);
                    }
                    isToken = false;
                    continue;
                }
                isToken = true;
                tokensb.setLength(0);
                continue;
            }
            if (isToken) {
                tokensb.append(String.valueOf(c));
                continue;
            }
            retsb.append(String.valueOf(c));
        }
        if (isToken) {
            throw new ValidationException("ERROR: configuration has a token defined without end-token [" + propValue + "] in the file: [" + (this.propFile != null ? this.propFile.getAbsolutePath() : "{no install.properties file specified using -p option}") + "]");
        }
        return retsb.toString();
    }

    class ValidationException
    extends Exception {
        public ValidationException(String msg) {
            super(msg);
        }

        public ValidationException(Throwable cause) {
            super(cause);
        }
    }
}

