/*
 * Decompiled with CFR 0.152.
 */
package org.apache.roller.weblogger.webservices.adminprotocol.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.Entry;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.EntrySet;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.MemberEntry;
import org.apache.roller.weblogger.webservices.adminprotocol.sdk.UnexpectedRootElementException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class MemberEntrySet
extends EntrySet {
    public MemberEntrySet(String urlPrefix) {
        this.setHref(urlPrefix + "/" + "members");
    }

    public MemberEntrySet(Document d, String urlPrefix) throws UnexpectedRootElementException {
        this.populate(d, urlPrefix);
    }

    public MemberEntrySet(InputStream stream, String urlPrefix) throws JDOMException, IOException, UnexpectedRootElementException {
        SAXBuilder sb = new SAXBuilder();
        Document d = sb.build(stream);
        this.populate(d, urlPrefix);
    }

    private void populate(Document d, String urlPrefix) throws UnexpectedRootElementException {
        Element root = d.getRootElement();
        String rootName = root.getName();
        if (!rootName.equals("members")) {
            throw new UnexpectedRootElementException("ERROR: Incorrect root element", "members", rootName);
        }
        List members = root.getChildren("member", NAMESPACE);
        if (members != null) {
            ArrayList<MemberEntry> entries = new ArrayList<MemberEntry>();
            for (Element member : members) {
                MemberEntry entry = new MemberEntry(member, urlPrefix);
                entries.add(entry);
            }
            this.setEntries(entries.toArray(new Entry[0]));
        }
        this.setHref(urlPrefix + "/" + "members");
    }

    public String getType() {
        return "members";
    }

    static interface Tags {
        public static final String MEMBERS = "members";
    }
}

