/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.ArrayList;
import java.util.List;
import reactor.core.dispatch.AbstractLifecycleDispatcher;

public abstract class SingleThreadDispatcher
extends AbstractLifecycleDispatcher {
    protected final List<AbstractLifecycleDispatcher.Task> tailRecursionPile = new ArrayList<AbstractLifecycleDispatcher.Task>();
    protected final int backlog;
    protected int tailRecurseSeq = -1;
    protected int tailRecursionPileSize = 0;

    public SingleThreadDispatcher(int backlog) {
        this.backlog = backlog;
        this.expandTailRecursionPile(backlog);
    }

    @Override
    public boolean supportsOrdering() {
        return true;
    }

    @Override
    public long backlogSize() {
        return this.backlog;
    }

    public int getTailRecursionPileSize() {
        return this.tailRecursionPileSize;
    }

    protected void expandTailRecursionPile(int amount) {
        int toAdd = amount * 2;
        for (int i = 0; i < toAdd; ++i) {
            this.tailRecursionPile.add(new SingleThreadTask());
        }
        this.tailRecursionPileSize += toAdd;
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateRecursiveTask() {
        int next;
        if ((next = ++this.tailRecurseSeq) == this.tailRecursionPileSize) {
            this.expandTailRecursionPile(this.backlog);
        }
        return this.tailRecursionPile.get(next);
    }

    @Override
    protected abstract AbstractLifecycleDispatcher.Task allocateTask();

    protected class SingleThreadTask
    extends AbstractLifecycleDispatcher.Task {
        protected SingleThreadTask() {
            super(SingleThreadDispatcher.this);
        }

        @Override
        public void run() {
            AbstractLifecycleDispatcher.route(this);
            if (SingleThreadDispatcher.this.tailRecurseSeq < 0) {
                return;
            }
            int next = -1;
            while (next < SingleThreadDispatcher.this.tailRecurseSeq) {
                AbstractLifecycleDispatcher.route(SingleThreadDispatcher.this.tailRecursionPile.get(++next));
            }
            next = SingleThreadDispatcher.this.tailRecurseSeq;
            int max = SingleThreadDispatcher.this.backlog * 2;
            while (next >= max) {
                SingleThreadDispatcher.this.tailRecursionPile.remove(next--);
            }
            SingleThreadDispatcher.this.tailRecursionPileSize = max;
            SingleThreadDispatcher.this.tailRecurseSeq = -1;
        }
    }
}

