/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.dropwizard.ReservoirFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public class DropwizardMetricServices
implements CounterService,
GaugeService {
    private final MetricRegistry registry;
    private final ReservoirFactory reservoirFactory;
    private final ConcurrentMap<String, SimpleGauge> gauges = new ConcurrentHashMap<String, SimpleGauge>();
    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap();

    public DropwizardMetricServices(MetricRegistry registry) {
        this(registry, null);
    }

    public DropwizardMetricServices(MetricRegistry registry, ReservoirFactory reservoirFactory) {
        this.registry = registry;
        this.reservoirFactory = reservoirFactory != null ? reservoirFactory : ReservoirFactory.NONE;
    }

    @Override
    public void increment(String name) {
        this.incrementInternal(name, 1L);
    }

    @Override
    public void decrement(String name) {
        this.incrementInternal(name, -1L);
    }

    private void incrementInternal(String name, long value) {
        if (name.startsWith("meter")) {
            Meter meter = this.registry.meter(name);
            meter.mark(value);
        } else {
            name = this.wrapCounterName(name);
            Counter counter = this.registry.counter(name);
            counter.inc(value);
        }
    }

    @Override
    public void submit(String name, double value) {
        if (name.startsWith("histogram")) {
            this.submitHistogram(name, value);
        } else if (name.startsWith("timer")) {
            this.submitTimer(name, value);
        } else {
            name = this.wrapGaugeName(name);
            this.setGaugeValue(name, value);
        }
    }

    private void submitTimer(String name, double value) {
        long longValue = (long)value;
        Timer metric = this.register(name, new TimerMetricRegistrar());
        metric.update(longValue, TimeUnit.MILLISECONDS);
    }

    private void submitHistogram(String name, double value) {
        long longValue = (long)value;
        Histogram metric = this.register(name, new HistogramMetricRegistrar());
        metric.update(longValue);
    }

    private <T extends Metric> T register(String name, MetricRegistrar<T> registrar) {
        Reservoir reservoir = this.reservoirFactory.getReservoir(name);
        if (reservoir == null) {
            return registrar.register(this.registry, name);
        }
        Metric metric = (Metric)this.registry.getMetrics().get(name);
        if (metric != null) {
            registrar.checkExisting(metric);
            return (T)metric;
        }
        try {
            return (T)this.registry.register(name, registrar.createForReservoir(reservoir));
        }
        catch (IllegalArgumentException ex) {
            Metric added = (Metric)this.registry.getMetrics().get(name);
            registrar.checkExisting(added);
            return (T)added;
        }
    }

    private void setGaugeValue(String name, double value) {
        SimpleGauge newGauge;
        SimpleGauge gauge = (SimpleGauge)this.gauges.get(name);
        if (gauge == null && (gauge = this.gauges.putIfAbsent(name, newGauge = new SimpleGauge(value))) == null) {
            this.registry.register(name, (Metric)newGauge);
            return;
        }
        gauge.setValue(value);
    }

    private String wrapGaugeName(String metricName) {
        return this.wrapName(metricName, "gauge.");
    }

    private String wrapCounterName(String metricName) {
        return this.wrapName(metricName, "counter.");
    }

    private String wrapName(String metricName, String prefix) {
        String cached = this.names.get(metricName);
        if (cached != null) {
            return cached;
        }
        if (metricName.startsWith(prefix)) {
            return metricName;
        }
        String name = prefix + metricName;
        this.names.put(metricName, name);
        return name;
    }

    @Override
    public void reset(String name) {
        if (!name.startsWith("meter")) {
            name = this.wrapCounterName(name);
        }
        this.registry.remove(name);
    }

    private static class HistogramMetricRegistrar
    extends MetricRegistrar<Histogram> {
        private HistogramMetricRegistrar() {
        }

        @Override
        protected Histogram register(MetricRegistry registry, String name) {
            return registry.histogram(name);
        }

        @Override
        protected Histogram createForReservoir(Reservoir reservoir) {
            return new Histogram(reservoir);
        }
    }

    private static class TimerMetricRegistrar
    extends MetricRegistrar<Timer> {
        private TimerMetricRegistrar() {
        }

        @Override
        protected Timer register(MetricRegistry registry, String name) {
            return registry.timer(name);
        }

        @Override
        protected Timer createForReservoir(Reservoir reservoir) {
            return new Timer(reservoir);
        }
    }

    private static abstract class MetricRegistrar<T extends Metric> {
        private final Class<T> type = ResolvableType.forClass(MetricRegistrar.class, this.getClass()).resolveGeneric(new int[0]);

        MetricRegistrar() {
        }

        public void checkExisting(Metric metric) {
            Assert.isInstanceOf(this.type, (Object)metric, (String)"Different metric type already registered");
        }

        protected abstract T register(MetricRegistry var1, String var2);

        protected abstract T createForReservoir(Reservoir var1);
    }

    private static final class SimpleGauge
    implements Gauge<Double> {
        private volatile double value;

        private SimpleGauge(double value) {
            this.value = value;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }
}

