/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import io.swagger.annotations.ApiOperation;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.MicroserviceInfo;

@Path(value="/v1/discovery")
public interface DiscoveryClient {
    @Path(value="/info")
    @GET
    @ApiOperation(value="", nickname="getInfo")
    public CompletableFuture<MicroserviceInfo> getInfoAsync(Endpoint var1, @QueryParam(value="service-id") String var2);

    default public MicroserviceInfo getInfo(Endpoint endpoint, String serviceId) {
        return (MicroserviceInfo)AsyncUtils.toSync(this.getInfoAsync(endpoint, serviceId));
    }

    @Path(value="/microservice")
    @GET
    @ApiOperation(value="", nickname="getMicroservice")
    public CompletableFuture<Microservice> getMicroserviceAsync(Endpoint var1, @QueryParam(value="service-id") String var2);

    default public Microservice getMicroservice(Endpoint endpoint, String serviceId) {
        return (Microservice)AsyncUtils.toSync(this.getMicroserviceAsync(endpoint, serviceId));
    }

    @Path(value="/instance")
    @GET
    @ApiOperation(value="", nickname="getInstance")
    public CompletableFuture<MicroserviceInstance> getInstanceAsync(Endpoint var1, @QueryParam(value="service-id") String var2);

    default public MicroserviceInstance getInstance(Endpoint endpoint, String serviceId) {
        return (MicroserviceInstance)AsyncUtils.toSync(this.getInstanceAsync(endpoint, serviceId));
    }

    @Path(value="/schemas/{schema-id}")
    @GET
    @Produces(value={"text/plain"})
    @ApiOperation(value="", nickname="getSchema")
    public CompletableFuture<String> getSchemaAsync(Endpoint var1, @QueryParam(value="service-id") String var2, @PathParam(value="schema-id") String var3);

    default public String getSchema(Endpoint endpoint, String serviceId, String schemaId) {
        return (String)AsyncUtils.toSync(this.getSchemaAsync(endpoint, serviceId, schemaId));
    }
}

