/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.parser;

import io.swagger.v3.oas.models.PathItem;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.provider.pojo.RpcSchema;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;
import org.apache.servicecomb.toolkit.generator.parser.AbstractAnnotationParser;

public class ServicecombPojoParser
extends AbstractAnnotationParser {
    public int getOrder() {
        return 100;
    }

    public boolean canProcess(Class<?> cls) {
        return cls.getAnnotation(RpcSchema.class) != null;
    }

    public void postParseMethodAnnotation(OperationContext context) {
        super.postParseMethodAnnotation(context);
        Method currentMethod = context.getMethod();
        if (StringUtils.isEmpty((CharSequence)context.getHttpMethod())) {
            context.setHttpMethod(PathItem.HttpMethod.POST.toString());
        }
        if (StringUtils.isEmpty((CharSequence)context.getOperationId())) {
            context.setOperationId(currentMethod.getName());
        }
        if (StringUtils.isEmpty((CharSequence)context.getPath())) {
            context.setPath(this.correctPath(currentMethod.getName()));
        }
        if (context.getApiResponses() == null || context.getApiResponses().size() == 0) {
            context.correctResponse(context.getApiResponses());
        }
    }

    private String correctPath(String path) {
        if (path == null || path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }
}

