/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.test;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;


/**
 * A marker annotation for platform-dependent tests. The platform-dependent part may
 * be the Operating System, or whether some dependencies are present or not.
 *
 * <p>This annotation is used in order to remember which part of the SIS library
 * (or its test suite) need to be revisited for better portability.</p>
 *
 * @author  Martin Desruisseaux (Geomatys)
 */
@Documented
@Target(ElementType.METHOD)
public @interface PlatformDependent {
}
