/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Name;

public class ChildInfoImpl
implements ChildInfo {
    private final Name name;
    private final String uniqueId;
    private final int index;
    private int hashCode;

    public ChildInfoImpl(Name name, String uniqueId, int index) {
        if (name == null || index < 0) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.uniqueId = uniqueId;
        this.index = index == 0 ? 1 : index;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public String getUniqueID() {
        return this.uniqueId;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.name.toString());
            sb.append("/");
            sb.append(this.index);
            sb.append("/");
            if (this.uniqueId != null) {
                sb.append(this.uniqueId);
            }
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChildInfoImpl) {
            ChildInfoImpl ci = (ChildInfoImpl)object;
            boolean sameUID = this.uniqueId == null ? ci.uniqueId == null : this.uniqueId.equals(ci.uniqueId);
            return sameUID && this.name.equals(ci.name) && this.index == ci.index;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name.toString());
        sb.append(" : ").append(this.index);
        sb.append(" : ").append(this.uniqueId == null ? "-" : this.uniqueId);
        return sb.toString();
    }
}

