/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.jspc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.sling.commons.classloader.ClassLoaderWriter;

public class JspCClassLoaderWriter
implements ClassLoaderWriter {
    private final ClassLoader loader;
    private final File rootDirectory;

    JspCClassLoaderWriter(ClassLoader loader, File rootDirectory) {
        this.loader = loader;
        this.rootDirectory = rootDirectory;
    }

    private File getFile(String fileName) {
        return new File(this.rootDirectory, fileName);
    }

    public OutputStream getOutputStream(String fileName) {
        try {
            return FileUtils.openOutputStream((File)this.getFile(fileName));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(String fileName) throws IOException {
        return FileUtils.openInputStream((File)this.getFile(fileName));
    }

    public long getLastModified(String fileName) {
        File file = this.getFile(fileName);
        if (file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    public boolean delete(String fileName) {
        return this.getFile(fileName).delete();
    }

    public boolean rename(String oldFileName, String newFileName) {
        return this.getFile(oldFileName).renameTo(this.getFile(newFileName));
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

