/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.listeners;

import java.util.Collections;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventHandler.class}, property={"event.topics=org/apache/sling/api/resource/Resource/CHANGED", "event.filter=(&(resourceType=sling:FileContent))"})
public class RenditionCleaner
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(RenditionCleaner.class);
    private ResourceResolverFactory factory;

    @Activate
    public RenditionCleaner(@Reference ResourceResolverFactory factory) {
        this.factory = factory;
    }

    public void handleEvent(Event event) {
        try (ResourceResolver resolver = this.factory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "sling-commons-thumbnails"));){
            Resource renditions = resolver.getResource(event.getProperty("path") + "/renditions");
            if (renditions != null) {
                resolver.delete(renditions);
                resolver.commit();
            }
        }
        catch (LoginException | PersistenceException e) {
            log.warn("Failed to remove renditions", e);
        }
    }
}

