/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.component.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.component.impl.DistributionComponentFactoryMap;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionConfiguration;
import org.apache.sling.distribution.component.impl.DistributionConfigurationManager;
import org.apache.sling.distribution.component.impl.OsgiConfigurationManager;
import org.apache.sling.distribution.component.impl.ResourceConfigurationManager;
import org.apache.sling.distribution.component.impl.SettingsUtils;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DistributionConfigurationManager.class})
@Designate(ocd=Config.class)
public class DefaultDistributionConfigurationManager
implements DistributionConfigurationManager {
    @Reference
    ConfigurationAdmin configurationAdmin;
    @Reference
    private DistributionComponentFactoryMap componentFactoryMap;
    private DistributionConfigurationManager osgiManager;
    private DistributionConfigurationManager resourceManager;
    private String resourcePrefix;
    static final String OSGI_PREFIX = "";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    void activate(ComponentContext ctx, Config conf) {
        boolean configEnabled = conf.resource_config_enabled();
        String configRoot = SettingsUtils.removeEmptyEntry(conf.resourceConfigRoot());
        this.resourcePrefix = SettingsUtils.removeEmptyEntry(conf.resourceConfigPrefix());
        String[] configProperties = SettingsUtils.removeEmptyEntries(conf.resourceConfigProperties());
        if (configEnabled && configRoot != null && configProperties != null) {
            Map configDefaults = PropertiesUtil.toMap((Object)conf.resourceConfigDefaults(), (String[])new String[0]);
            this.resourceManager = new ResourceConfigurationManager(configRoot, configProperties, configDefaults);
        }
        this.osgiManager = new OsgiConfigurationManager(this.configurationAdmin, this.componentFactoryMap, ctx.getServiceReference());
    }

    @Deactivate
    void deactivate() {
        this.resourceManager = null;
        this.osgiManager = null;
    }

    @Override
    public List<DistributionConfiguration> getConfigs(ResourceResolver resolver, DistributionComponentKind kind) {
        List<DistributionConfiguration> result = this.osgiManager.getConfigs(resolver, kind);
        if (this.resourceManager != null) {
            List<DistributionConfiguration> resourceConfigs = this.resourceManager.getConfigs(resolver, kind);
            result = DefaultDistributionConfigurationManager.mergeConfigs(result, resourceConfigs, this.resourcePrefix);
        }
        return result;
    }

    @Override
    public DistributionConfiguration getConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        DistributionConfiguration resultConfig = this.osgiManager.getConfig(resolver, kind, name);
        if (this.resourceManager != null) {
            DistributionConfiguration resourceConfig = this.resourceManager.getConfig(resolver, kind, name);
            resultConfig = DefaultDistributionConfigurationManager.mergeConfig(resultConfig, resourceConfig, this.resourcePrefix);
        }
        return resultConfig;
    }

    @Override
    public void saveConfig(ResourceResolver resolver, DistributionConfiguration config) {
        this.log.debug("saving config {}", (Object)config);
        if (this.resourceManager != null) {
            Map<String, DistributionConfiguration> splitConfig = DefaultDistributionConfigurationManager.splitConfig(config, this.resourcePrefix);
            DistributionConfiguration defaultConfig = splitConfig.get(OSGI_PREFIX);
            this.osgiManager.saveConfig(resolver, defaultConfig);
            DistributionConfiguration resourceConfig = splitConfig.get(this.resourcePrefix);
            this.log.debug("retrieved config {}", (Object)resourceConfig);
            if (resourceConfig != null) {
                this.resourceManager.saveConfig(resolver, resourceConfig);
                this.log.debug("saved resource config: {}", (Object)resourceConfig);
            }
        } else {
            this.osgiManager.saveConfig(resolver, config);
            this.log.debug("saved osgi config: {}", (Object)config);
        }
    }

    @Override
    public void deleteConfig(ResourceResolver resolver, DistributionComponentKind kind, String name) {
        this.osgiManager.deleteConfig(resolver, kind, name);
        if (this.resourceManager != null) {
            this.resourceManager.deleteConfig(resolver, kind, name);
        }
    }

    static DistributionConfiguration mergeConfig(DistributionConfiguration main, DistributionConfiguration extension, String prefix) {
        if (main == null) {
            return null;
        }
        HashMap<String, DistributionConfiguration> configMap = new HashMap<String, DistributionConfiguration>();
        configMap.put(OSGI_PREFIX, main);
        configMap.put(prefix, extension);
        return DefaultDistributionConfigurationManager.mergeConfig(main.getKind(), main.getName(), configMap);
    }

    static DistributionConfiguration mergeConfig(DistributionComponentKind kind, String name, Map<String, DistributionConfiguration> configMap) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String prefixKey : configMap.keySet()) {
            DistributionConfiguration config = configMap.get(prefixKey);
            if (config == null) continue;
            Map<String, Object> properties = config.getProperties();
            if (prefixKey.equals(OSGI_PREFIX)) {
                result.putAll(properties);
                continue;
            }
            for (String propertyKey : properties.keySet()) {
                Object propertyValue = properties.get(propertyKey);
                result.put(prefixKey + propertyKey, propertyValue);
            }
        }
        return new DistributionConfiguration(kind, name, result);
    }

    static List<DistributionConfiguration> mergeConfigs(List<DistributionConfiguration> target, List<DistributionConfiguration> source, String prefix) {
        ArrayList<DistributionConfiguration> result = new ArrayList<DistributionConfiguration>();
        HashMap<String, DistributionConfiguration> sourceMap = new HashMap<String, DistributionConfiguration>();
        for (DistributionConfiguration config : source) {
            sourceMap.put(config.getName(), config);
        }
        for (DistributionConfiguration targetConfig : target) {
            DistributionConfiguration sourceConfig = (DistributionConfiguration)sourceMap.get(targetConfig.getName());
            DistributionConfiguration mergedConfig = DefaultDistributionConfigurationManager.mergeConfig(targetConfig, sourceConfig, prefix);
            result.add(mergedConfig);
        }
        return result;
    }

    private static Map<String, DistributionConfiguration> splitConfig(DistributionConfiguration config, String prefix) {
        Map<String, Object> distributionConfigurationProperties = config.getProperties();
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        HashMap<String, Object> prefixMap = new HashMap<String, Object>();
        for (String configurationPropertyKey : distributionConfigurationProperties.keySet()) {
            if (configurationPropertyKey.startsWith(prefix)) {
                prefixMap.put(configurationPropertyKey.substring(prefix.length()), distributionConfigurationProperties.get(configurationPropertyKey));
                continue;
            }
            defaultMap.put(configurationPropertyKey, distributionConfigurationProperties.get(configurationPropertyKey));
        }
        HashMap<String, DistributionConfiguration> result = new HashMap<String, DistributionConfiguration>();
        result.put(OSGI_PREFIX, new DistributionConfiguration(config.getKind(), config.getName(), defaultMap));
        if (prefixMap.size() > 0) {
            result.put(prefix, new DistributionConfiguration(config.getKind(), config.getName(), prefixMap));
        }
        return result;
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="Resource Config enabled", description="If storing config in resource tree is enabled.")
        public boolean resource_config_enabled() default false;

        @AttributeDefinition(name="Resource Config prefix", description="The prefix of properties to be stored in content")
        public String resourceConfigPrefix() default "etc.";

        @AttributeDefinition(name="Resource Config Root", description="The resource config root")
        public String resourceConfigRoot() default "/etc/distribution";

        @AttributeDefinition(name="Resource Config Properties", description="The resource config properties")
        public String[] resourceConfigProperties() default {"enabled"};

        @AttributeDefinition(name="Resource Config Defaults", description="The default values for resource config properties")
        public String[] resourceConfigDefaults() default {"serializationType=distribution"};
    }
}

