/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.queue.impl;

import java.util.Calendar;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.sling.distribution.journal.queue.impl.EntryUtil;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemState;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;

public class QueueEntryFactory {
    private final String queueName;
    private final ToIntFunction<DistributionQueueItem> attemptsCallback;
    private final Function<DistributionQueueItem, Throwable> errorCallback;

    public QueueEntryFactory(String queueName, ToIntFunction<DistributionQueueItem> attemptsCallback, Function<DistributionQueueItem, Throwable> errorCallback) {
        this.queueName = queueName;
        this.attemptsCallback = attemptsCallback;
        this.errorCallback = errorCallback;
    }

    public DistributionQueueEntry create(DistributionQueueItem queueItem) {
        if (queueItem == null) {
            return null;
        }
        String entryId = EntryUtil.entryId(queueItem);
        DistributionQueueItemStatus itemStatus = this.buildQueueItemStatus(queueItem);
        return new DistributionQueueEntry(entryId, queueItem, itemStatus);
    }

    private DistributionQueueItemStatus buildQueueItemStatus(DistributionQueueItem queueItem) {
        int attempts = this.attemptsCallback.applyAsInt(queueItem);
        Throwable error = this.errorCallback.apply(queueItem);
        Calendar entered = this.itemCalendar(queueItem);
        return attempts > 0 ? new DistributionQueueItemStatus(entered, DistributionQueueItemState.ERROR, attempts, this.queueName, error) : new DistributionQueueItemStatus(entered, DistributionQueueItemState.QUEUED, attempts, this.queueName);
    }

    private Calendar itemCalendar(DistributionQueueItem queueItem) {
        long recordTimestamp = (Long)queueItem.get("recordTimestamp", Long.class);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(recordTimestamp);
        return calendar;
    }
}

