/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.spi;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.LauncherRunContext;

public interface Launcher {
    public void prepare(LauncherPrepareContext var1, ArtifactId var2, Feature var3) throws Exception;

    public int run(LauncherRunContext var1, ClassLoader var2) throws Exception;

    default public LauncherClassLoader createClassLoader() {
        return new LauncherClassLoader();
    }

    public static class LauncherClassLoader
    extends URLClassLoader {
        public LauncherClassLoader() {
            super(new URL[0]);
        }

        @Override
        public final void addURL(URL url) {
            super.addURL(url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz == null) {
                    try {
                        clazz = this.findClass(name);
                    }
                    catch (ClassNotFoundException cnfe) {
                        ClassLoader parent = this.getParent();
                        if (parent != null) {
                            clazz = parent.loadClass(name);
                        }
                        throw cnfe;
                    }
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }

        @Override
        public final URL getResource(String name) {
            URL resource = this.findResource(name);
            ClassLoader parent = this.getParent();
            if (resource == null && parent != null) {
                resource = parent.getResource(name);
            }
            return resource;
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

