/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.sling.jcr.base.internal.mount.ProxyAccessControlManager;
import org.apache.sling.jcr.base.internal.mount.ProxyItem;
import org.apache.sling.jcr.base.internal.mount.ProxyJackrabbitAccessControlManager;
import org.apache.sling.jcr.base.internal.mount.ProxyLock;
import org.apache.sling.jcr.base.internal.mount.ProxyNode;
import org.apache.sling.jcr.base.internal.mount.ProxyProperty;
import org.apache.sling.jcr.base.internal.mount.ProxyQueryResult;
import org.apache.sling.jcr.base.internal.mount.ProxyRepository;
import org.apache.sling.jcr.base.internal.mount.ProxyWorkspace;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ProxySession<T extends Session>
implements Session {
    private final ProxyRepository repository;
    public final T jcr;
    protected final Session mount;
    private final Set<String> mountPoints;
    private volatile Set<String> sync;
    private static final List<String> ignore = Arrays.asList("jcr:primaryType", "jcr:created", "jcr:createdBy");

    public ProxySession(ProxyRepository repository, T jcr, Session mount, Set<String> mountPoints) {
        this.repository = repository;
        this.jcr = jcr;
        this.mount = mount;
        this.mountPoints = mountPoints;
    }

    boolean isMount(String path) {
        return path != null && (this.mountPoints.contains(path) || this.mountPoints.stream().anyMatch(mountPoint -> path.startsWith(mountPoint + "/")));
    }

    boolean isMountParent(String path) {
        return this.mountPoints.stream().anyMatch(mountPoint -> mountPoint.startsWith((path + "/").replace("//", "/")));
    }

    boolean isMountDirectParent(String path) {
        return this.mountPoints.stream().anyMatch(mountPoint -> PathUtils.getParentPath((String)mountPoint).equals(path));
    }

    public <F> F wrap(F source) {
        if (source instanceof ProxyWrapper) {
            return source;
        }
        return (F)(source instanceof Node ? new ProxyNode(this, (Node)source) : (source instanceof Property ? new ProxyProperty(this, (Property)source) : (source instanceof Item ? new ProxyItem<Item>(this, (Item)source) : (source instanceof Lock ? new ProxyLock(this, (Lock)source) : (source instanceof QueryResult ? new ProxyQueryResult(this, (QueryResult)source) : source)))));
    }

    public <F> F unwrap(F source) {
        return (F)(source instanceof ProxyWrapper ? ((ProxyWrapper)source).delegate : source);
    }

    public NodeIterator wrap(final NodeIterator iter) {
        return new NodeIteratorAdapter((Iterator)new Iterator<Node>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Node next() {
                return ProxySession.this.wrap(iter.nextNode());
            }

            @Override
            public void remove() {
                iter.remove();
            }
        });
    }

    public PropertyIterator wrap(final PropertyIterator iter) {
        return new PropertyIterator(){

            public Property nextProperty() {
                return ProxySession.this.wrap(iter.nextProperty());
            }

            public void skip(long skipNum) {
                iter.skip(skipNum);
            }

            public long getSize() {
                return iter.getSize();
            }

            public long getPosition() {
                return iter.getPosition();
            }

            public boolean hasNext() {
                return iter.hasNext();
            }

            public void remove() {
                iter.remove();
            }

            public Object next() {
                return ProxySession.this.wrap(iter.next());
            }
        };
    }

    public RowIterator wrap(final RowIterator iter) {
        return new RowIterator(){

            public Row nextRow() {
                final Row row = iter.nextRow();
                return new Row(){

                    public Value[] getValues() throws RepositoryException {
                        return row.getValues();
                    }

                    public Value getValue(String s) throws ItemNotFoundException, RepositoryException {
                        return row.getValue(s);
                    }

                    public Node getNode() throws RepositoryException {
                        return ProxySession.this.wrap(row.getNode());
                    }

                    public Node getNode(String s) throws RepositoryException {
                        return ProxySession.this.wrap(row.getNode(s));
                    }

                    public String getPath() throws RepositoryException {
                        return row.getPath();
                    }

                    public String getPath(String s) throws RepositoryException {
                        return row.getPath(s);
                    }

                    public double getScore() throws RepositoryException {
                        return row.getScore();
                    }

                    public double getScore(String s) throws RepositoryException {
                        return row.getScore(s);
                    }
                };
            }

            public void skip(long l) {
                iter.skip(l);
            }

            public long getSize() {
                return iter.getSize();
            }

            public long getPosition() {
                return iter.getPosition();
            }

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() {
                return this.nextRow();
            }

            public void remove() {
                iter.remove();
            }
        };
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getUserID() {
        return this.jcr.getUserID();
    }

    public String[] getAttributeNames() {
        return this.jcr.getAttributeNames();
    }

    public Object getAttribute(String name) {
        return this.jcr.getAttribute(name);
    }

    public Node getRootNode() throws RepositoryException {
        return this.wrap(this.jcr.getRootNode());
    }

    public NodeIterator getNodes(String path, NodeIterator childs) throws RepositoryException {
        if (this.isMountDirectParent(path)) {
            ArrayList<Node> buffer = new ArrayList<Node>();
            while (childs.hasNext()) {
                Node child = childs.nextNode();
                if (this.isMount(child.getPath())) continue;
                buffer.add(child);
            }
            for (String mountPoint : this.mountPoints) {
                if (!PathUtils.getParentPath((String)mountPoint).equals(path)) continue;
                buffer.add(this.mount.getNode(mountPoint));
            }
            childs = new NodeIteratorAdapter(buffer);
        }
        return this.wrap(childs);
    }

    public boolean hasNodes(Node node) throws RepositoryException {
        return this.isMountDirectParent(node.getPath()) || node.hasNodes();
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        return this.repository.impersonate(credentials, (Session)this.jcr, this.mount);
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        try {
            return this.wrap(this.jcr.getNodeByUUID(uuid));
        }
        catch (RepositoryException ex) {
            try {
                return this.wrap(this.mount.getNodeByUUID(uuid));
            }
            catch (RepositoryException ignore) {
                throw ex;
            }
        }
    }

    public Node getNodeByIdentifier(String id) throws ItemNotFoundException, RepositoryException {
        try {
            return this.wrap(this.jcr.getNodeByIdentifier(id));
        }
        catch (RepositoryException ex) {
            try {
                return this.wrap(this.mount.getNodeByIdentifier(id));
            }
            catch (RepositoryException ignore) {
                throw ex;
            }
        }
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrap(this.isMount(absPath) ? this.mount.getItem(absPath) : this.jcr.getItem(absPath));
    }

    public Node getNode(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrap(this.isMount(absPath) ? this.mount.getNode(absPath) : this.jcr.getNode(absPath));
    }

    public Property getProperty(String absPath) throws PathNotFoundException, RepositoryException {
        return this.wrap(this.isMount(absPath) ? this.mount.getProperty(absPath) : this.jcr.getProperty(absPath));
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        return this.isMount(absPath) ? this.mount.itemExists(absPath) : this.jcr.itemExists(absPath);
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        return this.isMount(absPath) ? this.mount.nodeExists(absPath) : this.jcr.nodeExists(absPath);
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        return this.isMount(absPath) ? this.mount.propertyExists(absPath) : this.jcr.propertyExists(absPath);
    }

    public void removeItem(String absPath) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        if (this.sync != null) {
            this.sync.remove(absPath);
        }
        if (this.isMount(absPath)) {
            this.mount.removeItem(absPath);
        } else {
            this.jcr.removeItem(absPath);
            if (this.isMountParent(absPath)) {
                for (String mountPoint : this.mountPoints) {
                    if (!mountPoint.startsWith((absPath + "/").replace("//", "/"))) continue;
                    NodeIterator iter = this.mount.getNode(mountPoint).getNodes();
                    while (iter.hasNext()) {
                        iter.nextNode().remove();
                    }
                }
            }
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ReferentialIntegrityException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        if (this.sync != null) {
            for (String path : this.sync) {
                if (!this.jcr.nodeExists(path)) continue;
                Node jcrNode = this.jcr.getNode(path);
                Node mountNode = this.mount.nodeExists(path) ? this.mount.getNode(path) : this.mount.getNode(PathUtils.getParentPath((String)path)).addNode(PathUtils.getName((String)path), jcrNode.getPrimaryNodeType().getName());
                PropertyIterator iter = jcrNode.getProperties();
                while (iter.hasNext()) {
                    Property property = iter.nextProperty();
                    try {
                        if (property.isMultiple()) {
                            mountNode.setProperty(property.getName(), property.getValues());
                            continue;
                        }
                        mountNode.setProperty(property.getName(), property.getValue());
                    }
                    catch (ConstraintViolationException constraintViolationException) {}
                }
            }
            this.sync = null;
        }
        this.jcr.save();
        this.mount.save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.sync = null;
        this.jcr.refresh(keepChanges);
        this.mount.refresh(keepChanges);
    }

    public void refresh(String path, Item item, boolean keepChanges) throws RepositoryException {
        this.sync = null;
        item.refresh(keepChanges);
        if (!this.isMount(path) && this.isMountParent(path)) {
            this.mount.getRootNode().refresh(keepChanges);
        }
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return this.jcr.hasPendingChanges() || this.mount.hasPendingChanges();
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.jcr.getValueFactory();
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        return this.isMount(absPath) ? true : this.jcr.hasPermission(absPath, actions);
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        if (!this.isMount(absPath)) {
            this.jcr.checkPermission(absPath, actions);
        }
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        return this.jcr.hasCapability(methodName, target, arguments);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        if (this.isMount(parentAbsPath)) {
            return this.mount.getImportContentHandler(parentAbsPath, uuidBehavior);
        }
        return this.jcr.getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        if (this.isMount(parentAbsPath)) {
            this.mount.importXML(parentAbsPath, in, uuidBehavior);
        } else {
            this.jcr.importXML(parentAbsPath, in, uuidBehavior);
        }
    }

    public void exportSystemView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        if (this.isMount(absPath)) {
            this.mount.exportSystemView(absPath, contentHandler, skipBinary, noRecurse);
        } else {
            this.jcr.exportSystemView(absPath, contentHandler, skipBinary, noRecurse);
        }
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        if (this.isMount(absPath)) {
            this.mount.exportSystemView(absPath, out, skipBinary, noRecurse);
        } else {
            this.jcr.exportSystemView(absPath, out, skipBinary, noRecurse);
        }
    }

    public void exportDocumentView(String absPath, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws PathNotFoundException, SAXException, RepositoryException {
        if (this.isMount(absPath)) {
            this.mount.exportDocumentView(absPath, contentHandler, skipBinary, noRecurse);
        } else {
            this.jcr.exportDocumentView(absPath, contentHandler, skipBinary, noRecurse);
        }
    }

    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, PathNotFoundException, RepositoryException {
        if (this.isMount(absPath)) {
            this.mount.exportDocumentView(absPath, out, skipBinary, noRecurse);
        } else {
            this.jcr.exportDocumentView(absPath, out, skipBinary, noRecurse);
        }
    }

    public void setNamespacePrefix(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.jcr.setNamespacePrefix(prefix, uri);
        this.mount.setNamespacePrefix(prefix, uri);
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        return this.jcr.getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) throws NamespaceException, RepositoryException {
        return this.jcr.getNamespaceURI(prefix);
    }

    public String getNamespacePrefix(String uri) throws NamespaceException, RepositoryException {
        return this.jcr.getNamespacePrefix(uri);
    }

    public void logout() {
        this.jcr.logout();
        this.mount.logout();
    }

    public boolean isLive() {
        return this.jcr.isLive();
    }

    public void addLockToken(String lt) {
        this.jcr.addLockToken(lt);
    }

    public String[] getLockTokens() {
        return this.jcr.getLockTokens();
    }

    public void removeLockToken(String lt) {
        this.jcr.removeLockToken(lt);
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        AccessControlManager manager = this.jcr.getAccessControlManager();
        return manager instanceof JackrabbitAccessControlManager ? new ProxyJackrabbitAccessControlManager(this, (JackrabbitAccessControlManager)manager, (JackrabbitAccessControlManager)this.mount.getAccessControlManager()) : new ProxyAccessControlManager<AccessControlManager>(this, manager, this.mount.getAccessControlManager());
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.jcr.getRetentionManager();
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (this.isMount(srcAbsPath) && this.isMount(destAbsPath)) {
            this.mount.move(srcAbsPath, destAbsPath);
        } else if (!this.isMount(srcAbsPath) && !this.isMount(destAbsPath)) {
            this.jcr.move(srcAbsPath, destAbsPath);
        } else {
            throw new IllegalStateException("Move between jcr and mount not supported");
        }
    }

    public Workspace getWorkspace() {
        return new ProxyWorkspace<Workspace>(this, this.jcr.getWorkspace(), this.mount.getWorkspace());
    }

    public Node addNode(String parent, String path, String name) throws RepositoryException {
        if (this.isMount(path)) {
            return this.wrap(this.mount.getNode(parent).addNode(name));
        }
        if (this.isMountParent(path)) {
            this.mount.getNode(parent).addNode(name);
            if (this.sync == null) {
                this.sync = new HashSet<String>();
            }
            this.sync.add(path);
        }
        return this.wrap(this.jcr.getNode(parent).addNode(name));
    }

    public Node addNode(String parent, String path, String name, String type) throws RepositoryException {
        if (this.isMount(path)) {
            return this.wrap(this.mount.getNode(parent).addNode(name, type));
        }
        if (this.isMountParent(path)) {
            this.mount.getNode(parent).addNode(name, type);
            if (this.sync == null) {
                this.sync = new HashSet<String>();
            }
            this.sync.add(path);
        }
        return this.wrap(this.jcr.getNode(parent).addNode(name, type));
    }
}

