/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.davex.impl.servlets;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.server.remoting.davex.JcrRemotingServlet;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@ServiceVendor(value="The Apache Software Foundation")
@ServiceDescription(value="Sling JcrRemoting Servlet")
@Designate(ocd=Config.class)
public class SlingDavExServlet
extends JcrRemotingServlet {
    protected static final String SERVICE_VENDOR = "The Apache Software Foundation";
    protected static final String SERVICE_DESCRIPTION = "Sling JcrRemoting Servlet";
    private static final String DEFAULT_DAV_ROOT = "/server";
    private static final String DEFAULT_PROTECTED_HANDLERS = "org.apache.jackrabbit.server.remoting.davex.AclRemoveHandler";
    private static final String PAR_AUTH_REQ = "sling.auth.requirements";
    private static char[] EMPTY_PW = new char[0];
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private SlingRepository repository;
    private ServiceRegistration davServlet;

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        String davRoot = config.alias();
        boolean createAbsoluteUri = config.dav_create$_$absolute$_$uri();
        String protectedHandlers = config.dav_protectedhandlers();
        Hashtable<String, String> initProps = new Hashtable<String, String>();
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("resource-path-prefix"), davRoot);
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("createAbsoluteURI"), Boolean.toString(createAbsoluteUri));
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("csrf-protection"), "disabled");
        ((Dictionary)initProps).put(SlingDavExServlet.toInitParamProperty("protectedhandlers-config"), protectedHandlers);
        ((Dictionary)initProps).put("osgi.http.whiteboard.servlet.pattern", davRoot.concat("/*"));
        ((Dictionary)initProps).put("service.vendor", SERVICE_VENDOR);
        ((Dictionary)initProps).put("service.description", SERVICE_DESCRIPTION);
        ((Dictionary)initProps).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=DavExAuthHttpContext)");
        ((Dictionary)initProps).put(PAR_AUTH_REQ, "-" + davRoot);
        this.davServlet = bundleContext.registerService(Servlet.class.getName(), (Object)this, initProps);
    }

    @Deactivate
    protected void deactivate() {
        if (this.davServlet != null) {
            this.davServlet.unregister();
            this.davServlet = null;
        }
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected SessionProvider getSessionProvider() {
        return new SessionProvider(){

            @Override
            public Session getSession(HttpServletRequest req, Repository repository, String workspace) throws LoginException, RepositoryException, ServletException {
                Session session;
                ResourceResolver resolver = (ResourceResolver)req.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                if (resolver != null && (session = (Session)resolver.adaptTo(Session.class)) != null) {
                    Session newSession = this.getLongLivedSession(session);
                    SlingDavExServlet.this.log.debug("getSession: Creating new Session ({}) for {}", (Object)newSession, (Object)newSession.getUserID());
                    return newSession;
                }
                throw new ServletException("ResourceResolver missing or not providing on JCR Session");
            }

            @Override
            public void releaseSession(Session session) {
                SlingDavExServlet.this.log.debug("releaseSession: Logging out long lived Session ({})", (Object)session);
                session.logout();
            }

            private Session getLongLivedSession(Session slingSession) throws RepositoryException {
                String user = slingSession.getUserID();
                try {
                    SimpleCredentials credentials = new SimpleCredentials(user, EMPTY_PW);
                    return slingSession.impersonate((Credentials)credentials);
                }
                catch (Exception re) {
                    throw new RepositoryException("Cannot get session for " + user, (Throwable)re);
                }
            }
        };
    }

    private static String toInitParamProperty(String name) {
        return "servlet.init.".concat(name);
    }

    @ObjectClassDefinition(name="%dav.name", description="%dav.description")
    public static @interface Config {
        @AttributeDefinition(name="%alias.name", description="%alias.description")
        public String alias() default "/server";

        @AttributeDefinition(name="%dav.create-absolute-uri.name", description="%dav.create-absolute-uri.description")
        public boolean dav_create$_$absolute$_$uri() default true;

        @AttributeDefinition
        public String dav_protectedhandlers() default "org.apache.jackrabbit.server.remoting.davex.AclRemoveHandler";
    }
}

