/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.value.ValueHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AccessControlEntryImpl
implements JackrabbitAccessControlEntry {
    private final Privilege[] privileges;
    private final int privilegeBits;
    private final Principal principal;
    private final boolean allow;
    private final Map<Name, Value> restrictions;
    private int hashCode = -1;

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        this(principal, privileges, true, null);
    }

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges, boolean isAllow, Map<String, Value> restrictions) throws AccessControlException, RepositoryException {
        if (principal == null) {
            throw new IllegalArgumentException();
        }
        for (Privilege privilege : privileges) {
            if (!privilege.isAbstract()) continue;
            throw new AccessControlException("Privilege " + privilege + " is abstract.");
        }
        this.principal = principal;
        this.privileges = privileges;
        this.privilegeBits = PrivilegeRegistry.getBits(privileges);
        this.allow = isAllow;
        if (restrictions == null) {
            this.restrictions = Collections.emptyMap();
        } else {
            this.restrictions = new HashMap<Name, Value>(restrictions.size());
            for (String key : restrictions.keySet()) {
                Value value = restrictions.get(key);
                value = ValueHelper.copy(value, this.getValueFactory());
                this.restrictions.put(this.getResolver().getQName(key), value);
            }
        }
    }

    protected AccessControlEntryImpl(AccessControlEntryImpl base, Privilege[] privileges, boolean isAllow) throws AccessControlException {
        for (Privilege privilege : privileges) {
            if (!privilege.isAbstract()) continue;
            throw new AccessControlException("Privilege " + privilege + " is abstract.");
        }
        this.principal = base.principal;
        this.privileges = privileges;
        this.privilegeBits = PrivilegeRegistry.getBits(privileges);
        this.allow = isAllow;
        if (base.restrictions == null) {
            this.restrictions = Collections.emptyMap();
        } else {
            this.restrictions = new HashMap<Name, Value>(base.restrictions.size());
            for (Name name : this.restrictions.keySet()) {
                Value value = this.restrictions.get(name);
                value = ValueHelper.copy(value, this.getValueFactory());
                this.restrictions.put(name, value);
            }
        }
    }

    public int getPrivilegeBits() {
        return this.privilegeBits;
    }

    public boolean hasRestrictions() {
        return !this.restrictions.isEmpty();
    }

    public Map<Name, Value> getRestrictions() {
        return Collections.unmodifiableMap(this.restrictions);
    }

    public Value getRestriction(Name restrictionName) {
        return ValueHelper.copy(this.restrictions.get(restrictionName), this.getValueFactory());
    }

    protected abstract NameResolver getResolver();

    protected abstract ValueFactory getValueFactory();

    protected int buildHashCode() {
        int h = 17;
        h = 37 * h + this.principal.getName().hashCode();
        h = 37 * h + this.privilegeBits;
        h = 37 * h + Boolean.valueOf(this.allow).hashCode();
        h = 37 * h + ((Object)this.restrictions).hashCode();
        return h;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Privilege[] getPrivileges() {
        return this.privileges;
    }

    @Override
    public boolean isAllow() {
        return this.allow;
    }

    @Override
    public String[] getRestrictionNames() throws NamespaceException {
        String[] restrNames = new String[this.restrictions.size()];
        int i = 0;
        for (Name n : this.restrictions.keySet()) {
            restrNames[i] = this.getResolver().getJCRName(n);
            ++i;
        }
        return restrNames;
    }

    @Override
    public Value getRestriction(String restrictionName) throws RepositoryException {
        return this.getRestriction(this.getResolver().getQName(restrictionName));
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.buildHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlEntryImpl) {
            AccessControlEntryImpl tmpl = (AccessControlEntryImpl)obj;
            return this.principal.getName().equals(tmpl.principal.getName()) && this.privilegeBits == tmpl.privilegeBits && this.allow == tmpl.allow && ((Object)this.restrictions).equals(tmpl.restrictions);
        }
        return false;
    }
}

