/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.sling.validation.impl.model.ResourcePropertyImpl;
import org.apache.sling.validation.impl.model.ValidatorInvocationImpl;
import org.apache.sling.validation.model.ResourceProperty;
import org.apache.sling.validation.model.ValidatorInvocation;

public class ResourcePropertyBuilder {
    private boolean optional = false;
    private boolean multiple = false;
    private String nameRegex = null;
    @Nonnull
    private final List<ValidatorInvocation> validators = new ArrayList<ValidatorInvocation>();

    @Nonnull
    public ResourcePropertyBuilder nameRegex(String nameRegex) {
        this.nameRegex = nameRegex;
        return this;
    }

    @Nonnull
    public ResourcePropertyBuilder validator(@Nonnull String id, Integer severity, String ... parametersNamesAndValues) {
        if (parametersNamesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("array parametersNamesAndValues must be even! (first specify name then value, separated by comma)");
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (int i = 0; i < parametersNamesAndValues.length; i += 2) {
            parameterMap.put(parametersNamesAndValues[i], parametersNamesAndValues[i + 1]);
        }
        return this.validator(id, severity, parameterMap);
    }

    @Nonnull
    public ResourcePropertyBuilder validator(@Nonnull String id, Integer severity, @Nonnull Map<String, Object> parameters) {
        this.validators.add(new ValidatorInvocationImpl(id, parameters, severity));
        return this;
    }

    @Nonnull
    public ResourcePropertyBuilder optional() {
        this.optional = true;
        return this;
    }

    @Nonnull
    public ResourcePropertyBuilder multiple() {
        this.multiple = true;
        return this;
    }

    @Nonnull
    public ResourceProperty build(@Nonnull String name) {
        return new ResourcePropertyImpl(name, this.nameRegex, this.multiple, !this.optional, this.validators);
    }
}

