/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class PartitionSpec
implements TBase<PartitionSpec, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("PartitionSpec");
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 1);
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 2);
    private static final TField ROOT_PATH_FIELD_DESC = new TField("rootPath", 11, 3);
    private static final TField SHARED_SDPARTITION_SPEC_FIELD_DESC = new TField("sharedSDPartitionSpec", 12, 4);
    private static final TField PARTITION_LIST_FIELD_DESC = new TField("partitionList", 12, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private String dbName;
    private String tableName;
    private String rootPath;
    private PartitionSpecWithSharedSD sharedSDPartitionSpec;
    private PartitionListComposingSpec partitionList;
    private _Fields[] optionals = new _Fields[]{_Fields.SHARED_SDPARTITION_SPEC, _Fields.PARTITION_LIST};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public PartitionSpec() {
    }

    public PartitionSpec(String dbName, String tableName, String rootPath) {
        this();
        this.dbName = dbName;
        this.tableName = tableName;
        this.rootPath = rootPath;
    }

    public PartitionSpec(PartitionSpec other) {
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetRootPath()) {
            this.rootPath = other.rootPath;
        }
        if (other.isSetSharedSDPartitionSpec()) {
            this.sharedSDPartitionSpec = new PartitionSpecWithSharedSD(other.sharedSDPartitionSpec);
        }
        if (other.isSetPartitionList()) {
            this.partitionList = new PartitionListComposingSpec(other.partitionList);
        }
    }

    public PartitionSpec deepCopy() {
        return new PartitionSpec(this);
    }

    public void clear() {
        this.dbName = null;
        this.tableName = null;
        this.rootPath = null;
        this.sharedSDPartitionSpec = null;
        this.partitionList = null;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void unsetRootPath() {
        this.rootPath = null;
    }

    public boolean isSetRootPath() {
        return this.rootPath != null;
    }

    public void setRootPathIsSet(boolean value) {
        if (!value) {
            this.rootPath = null;
        }
    }

    public PartitionSpecWithSharedSD getSharedSDPartitionSpec() {
        return this.sharedSDPartitionSpec;
    }

    public void setSharedSDPartitionSpec(PartitionSpecWithSharedSD sharedSDPartitionSpec) {
        this.sharedSDPartitionSpec = sharedSDPartitionSpec;
    }

    public void unsetSharedSDPartitionSpec() {
        this.sharedSDPartitionSpec = null;
    }

    public boolean isSetSharedSDPartitionSpec() {
        return this.sharedSDPartitionSpec != null;
    }

    public void setSharedSDPartitionSpecIsSet(boolean value) {
        if (!value) {
            this.sharedSDPartitionSpec = null;
        }
    }

    public PartitionListComposingSpec getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(PartitionListComposingSpec partitionList) {
        this.partitionList = partitionList;
    }

    public void unsetPartitionList() {
        this.partitionList = null;
    }

    public boolean isSetPartitionList() {
        return this.partitionList != null;
    }

    public void setPartitionListIsSet(boolean value) {
        if (!value) {
            this.partitionList = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case TABLE_NAME: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case ROOT_PATH: {
                if (value == null) {
                    this.unsetRootPath();
                    break;
                }
                this.setRootPath((String)value);
                break;
            }
            case SHARED_SDPARTITION_SPEC: {
                if (value == null) {
                    this.unsetSharedSDPartitionSpec();
                    break;
                }
                this.setSharedSDPartitionSpec((PartitionSpecWithSharedSD)value);
                break;
            }
            case PARTITION_LIST: {
                if (value == null) {
                    this.unsetPartitionList();
                    break;
                }
                this.setPartitionList((PartitionListComposingSpec)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DB_NAME: {
                return this.getDbName();
            }
            case TABLE_NAME: {
                return this.getTableName();
            }
            case ROOT_PATH: {
                return this.getRootPath();
            }
            case SHARED_SDPARTITION_SPEC: {
                return this.getSharedSDPartitionSpec();
            }
            case PARTITION_LIST: {
                return this.getPartitionList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DB_NAME: {
                return this.isSetDbName();
            }
            case TABLE_NAME: {
                return this.isSetTableName();
            }
            case ROOT_PATH: {
                return this.isSetRootPath();
            }
            case SHARED_SDPARTITION_SPEC: {
                return this.isSetSharedSDPartitionSpec();
            }
            case PARTITION_LIST: {
                return this.isSetPartitionList();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof PartitionSpec) {
            return this.equals((PartitionSpec)that);
        }
        return false;
    }

    public boolean equals(PartitionSpec that) {
        if (that == null) {
            return false;
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_rootPath = this.isSetRootPath();
        boolean that_present_rootPath = that.isSetRootPath();
        if (this_present_rootPath || that_present_rootPath) {
            if (!this_present_rootPath || !that_present_rootPath) {
                return false;
            }
            if (!this.rootPath.equals(that.rootPath)) {
                return false;
            }
        }
        boolean this_present_sharedSDPartitionSpec = this.isSetSharedSDPartitionSpec();
        boolean that_present_sharedSDPartitionSpec = that.isSetSharedSDPartitionSpec();
        if (this_present_sharedSDPartitionSpec || that_present_sharedSDPartitionSpec) {
            if (!this_present_sharedSDPartitionSpec || !that_present_sharedSDPartitionSpec) {
                return false;
            }
            if (!this.sharedSDPartitionSpec.equals(that.sharedSDPartitionSpec)) {
                return false;
            }
        }
        boolean this_present_partitionList = this.isSetPartitionList();
        boolean that_present_partitionList = that.isSetPartitionList();
        if (this_present_partitionList || that_present_partitionList) {
            if (!this_present_partitionList || !that_present_partitionList) {
                return false;
            }
            if (!this.partitionList.equals(that.partitionList)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        boolean present_dbName = this.isSetDbName();
        builder.append(present_dbName);
        if (present_dbName) {
            builder.append((Object)this.dbName);
        }
        boolean present_tableName = this.isSetTableName();
        builder.append(present_tableName);
        if (present_tableName) {
            builder.append((Object)this.tableName);
        }
        boolean present_rootPath = this.isSetRootPath();
        builder.append(present_rootPath);
        if (present_rootPath) {
            builder.append((Object)this.rootPath);
        }
        boolean present_sharedSDPartitionSpec = this.isSetSharedSDPartitionSpec();
        builder.append(present_sharedSDPartitionSpec);
        if (present_sharedSDPartitionSpec) {
            builder.append((Object)this.sharedSDPartitionSpec);
        }
        boolean present_partitionList = this.isSetPartitionList();
        builder.append(present_partitionList);
        if (present_partitionList) {
            builder.append((Object)this.partitionList);
        }
        return builder.toHashCode();
    }

    public int compareTo(PartitionSpec other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        PartitionSpec typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetDbName()).compareTo(typedOther.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)typedOther.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTableName()).compareTo(typedOther.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)typedOther.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRootPath()).compareTo(typedOther.isSetRootPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRootPath() && (lastComparison = TBaseHelper.compareTo((String)this.rootPath, (String)typedOther.rootPath)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSharedSDPartitionSpec()).compareTo(typedOther.isSetSharedSDPartitionSpec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSharedSDPartitionSpec() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.sharedSDPartitionSpec), (Comparable)((Object)typedOther.sharedSDPartitionSpec))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartitionList()).compareTo(typedOther.isSetPartitionList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionList() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.partitionList), (Comparable)((Object)typedOther.partitionList))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionSpec(");
        boolean first = true;
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("rootPath:");
        if (this.rootPath == null) {
            sb.append("null");
        } else {
            sb.append(this.rootPath);
        }
        first = false;
        if (this.isSetSharedSDPartitionSpec()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sharedSDPartitionSpec:");
            if (this.sharedSDPartitionSpec == null) {
                sb.append("null");
            } else {
                sb.append(this.sharedSDPartitionSpec);
            }
            first = false;
        }
        if (this.isSetPartitionList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partitionList:");
            if (this.partitionList == null) {
                sb.append("null");
            } else {
                sb.append(this.partitionList);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.sharedSDPartitionSpec != null) {
            this.sharedSDPartitionSpec.validate();
        }
        if (this.partitionList != null) {
            this.partitionList.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new PartitionSpecStandardSchemeFactory());
        schemes.put(TupleScheme.class, new PartitionSpecTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ROOT_PATH, new FieldMetaData("rootPath", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SHARED_SDPARTITION_SPEC, new FieldMetaData("sharedSDPartitionSpec", 2, (FieldValueMetaData)new StructMetaData(12, PartitionSpecWithSharedSD.class)));
        tmpMap.put(_Fields.PARTITION_LIST, new FieldMetaData("partitionList", 2, (FieldValueMetaData)new StructMetaData(12, PartitionListComposingSpec.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(PartitionSpec.class, metaDataMap);
    }

    private static class PartitionSpecTupleScheme
    extends TupleScheme<PartitionSpec> {
        private PartitionSpecTupleScheme() {
        }

        public void write(TProtocol prot, PartitionSpec struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetDbName()) {
                optionals.set(0);
            }
            if (struct.isSetTableName()) {
                optionals.set(1);
            }
            if (struct.isSetRootPath()) {
                optionals.set(2);
            }
            if (struct.isSetSharedSDPartitionSpec()) {
                optionals.set(3);
            }
            if (struct.isSetPartitionList()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetDbName()) {
                oprot.writeString(struct.dbName);
            }
            if (struct.isSetTableName()) {
                oprot.writeString(struct.tableName);
            }
            if (struct.isSetRootPath()) {
                oprot.writeString(struct.rootPath);
            }
            if (struct.isSetSharedSDPartitionSpec()) {
                struct.sharedSDPartitionSpec.write((TProtocol)oprot);
            }
            if (struct.isSetPartitionList()) {
                struct.partitionList.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, PartitionSpec struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.dbName = iprot.readString();
                struct.setDbNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.rootPath = iprot.readString();
                struct.setRootPathIsSet(true);
            }
            if (incoming.get(3)) {
                struct.sharedSDPartitionSpec = new PartitionSpecWithSharedSD();
                struct.sharedSDPartitionSpec.read((TProtocol)iprot);
                struct.setSharedSDPartitionSpecIsSet(true);
            }
            if (incoming.get(4)) {
                struct.partitionList = new PartitionListComposingSpec();
                struct.partitionList.read((TProtocol)iprot);
                struct.setPartitionListIsSet(true);
            }
        }
    }

    private static class PartitionSpecTupleSchemeFactory
    implements SchemeFactory {
        private PartitionSpecTupleSchemeFactory() {
        }

        public PartitionSpecTupleScheme getScheme() {
            return new PartitionSpecTupleScheme();
        }
    }

    private static class PartitionSpecStandardScheme
    extends StandardScheme<PartitionSpec> {
        private PartitionSpecStandardScheme() {
        }

        public void read(TProtocol iprot, PartitionSpec struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readString();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.rootPath = iprot.readString();
                            struct.setRootPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.sharedSDPartitionSpec = new PartitionSpecWithSharedSD();
                            struct.sharedSDPartitionSpec.read(iprot);
                            struct.setSharedSDPartitionSpecIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.partitionList = new PartitionListComposingSpec();
                            struct.partitionList.read(iprot);
                            struct.setPartitionListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, PartitionSpec struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.rootPath != null) {
                oprot.writeFieldBegin(ROOT_PATH_FIELD_DESC);
                oprot.writeString(struct.rootPath);
                oprot.writeFieldEnd();
            }
            if (struct.sharedSDPartitionSpec != null && struct.isSetSharedSDPartitionSpec()) {
                oprot.writeFieldBegin(SHARED_SDPARTITION_SPEC_FIELD_DESC);
                struct.sharedSDPartitionSpec.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.partitionList != null && struct.isSetPartitionList()) {
                oprot.writeFieldBegin(PARTITION_LIST_FIELD_DESC);
                struct.partitionList.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class PartitionSpecStandardSchemeFactory
    implements SchemeFactory {
        private PartitionSpecStandardSchemeFactory() {
        }

        public PartitionSpecStandardScheme getScheme() {
            return new PartitionSpecStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DB_NAME(1, "dbName"),
        TABLE_NAME(2, "tableName"),
        ROOT_PATH(3, "rootPath"),
        SHARED_SDPARTITION_SPEC(4, "sharedSDPartitionSpec"),
        PARTITION_LIST(5, "partitionList");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DB_NAME;
                }
                case 2: {
                    return TABLE_NAME;
                }
                case 3: {
                    return ROOT_PATH;
                }
                case 4: {
                    return SHARED_SDPARTITION_SPEC;
                }
                case 5: {
                    return PARTITION_LIST;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

