/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.BaseStructObjectInspector;
import org.apache.hadoop.hive.serde2.StructObject;
import org.apache.hadoop.hive.serde2.avro.AvroLazyObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Text;

public class LazySimpleStructObjectInspector
extends BaseStructObjectInspector {
    private byte separator;
    private Text nullSequence;
    private boolean lastColumnTakesRest;
    private boolean escaped;
    private byte escapeChar;

    protected LazySimpleStructObjectInspector() {
    }

    protected LazySimpleStructObjectInspector(List<StructField> fields, byte separator, Text nullSequence) {
        this.init(fields);
        this.separator = separator;
        this.nullSequence = nullSequence;
    }

    @Deprecated
    protected LazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        this.init(structFieldNames, structFieldObjectInspectors, null, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
    }

    public LazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        this.init(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
    }

    protected void init(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        this.init(structFieldNames, structFieldObjectInspectors, structFieldComments);
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.escaped = escaped;
        this.escapeChar = escapeChar;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        ObjectInspector valueOI;
        if (data == null) {
            return null;
        }
        StructObject struct = (StructObject)data;
        BaseStructObjectInspector.MyField f = (BaseStructObjectInspector.MyField)fieldRef;
        int fieldID = f.getFieldID();
        assert (fieldID >= 0 && fieldID < this.fields.size());
        ObjectInspector oi = f.getFieldObjectInspector();
        if (oi instanceof AvroLazyObjectInspector) {
            return ((AvroLazyObjectInspector)oi).getStructFieldData(data, fieldRef);
        }
        if (oi instanceof MapObjectInspector && (valueOI = ((MapObjectInspector)oi).getMapValueObjectInspector()) instanceof AvroLazyObjectInspector) {
            return ((AvroLazyObjectInspector)valueOI).getStructFieldData(data, fieldRef);
        }
        return struct.getField(fieldID);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(this.fields.size());
        for (BaseStructObjectInspector.MyField myField : this.fields) {
            result.add(this.getStructFieldData(data, myField));
        }
        return result;
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Text getNullSequence() {
        return this.nullSequence;
    }

    public boolean getLastColumnTakesRest() {
        return this.lastColumnTakesRest;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }
}

