/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;

@Named
public class DefaultOfflineController
implements OfflineController,
Service {
    static final String CONFIG_PROP_OFFLINE_PROTOCOLS = "aether.offline.protocols";
    static final String CONFIG_PROP_OFFLINE_HOSTS = "aether.offline.hosts";
    private static final Pattern SEP = Pattern.compile("\\s*,\\s*");
    private Logger logger = NullLoggerFactory.LOGGER;

    public DefaultOfflineController() {
    }

    @Inject
    DefaultOfflineController(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public DefaultOfflineController setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public void checkOffline(RepositorySystemSession session, RemoteRepository repository) throws RepositoryOfflineException {
        if (this.isOfflineProtocol(session, repository) || this.isOfflineHost(session, repository)) {
            return;
        }
        throw new RepositoryOfflineException(repository);
    }

    private boolean isOfflineProtocol(RepositorySystemSession session, RemoteRepository repository) {
        String protocol;
        String[] protocols = this.getConfig(session, CONFIG_PROP_OFFLINE_PROTOCOLS);
        if (protocols != null && (protocol = repository.getProtocol()).length() > 0) {
            for (String p : protocols) {
                if (!p.equalsIgnoreCase(protocol)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOfflineHost(RepositorySystemSession session, RemoteRepository repository) {
        String host;
        String[] hosts = this.getConfig(session, CONFIG_PROP_OFFLINE_HOSTS);
        if (hosts != null && (host = repository.getHost()).length() > 0) {
            for (String h : hosts) {
                if (!h.equalsIgnoreCase(host)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getConfig(RepositorySystemSession session, String key) {
        String value = ConfigUtils.getString(session, "", key).trim();
        if (value.length() <= 0) {
            return null;
        }
        return SEP.split(value);
    }
}

