/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.ImplicitBindings;
import org.eclipse.sisu.inject.InjectorPublisher;
import org.eclipse.sisu.inject.LocatedBeans;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankedBindings;
import org.eclipse.sisu.inject.RankedSequence;
import org.eclipse.sisu.inject.RankingFunction;
import org.eclipse.sisu.inject.Soft;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.inject.WatchedBeans;
import org.eclipse.sisu.inject.Weak;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<TypeLiteral, RankedBindings> cachedBindings = Soft.concurrentValues(256, 8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<BeanEntry> locate(Key key) {
        TypeLiteral type = key.getTypeLiteral();
        RankedBindings bindings = (RankedBindings)this.cachedBindings.get(type);
        if (bindings == null) {
            ConcurrentMap<TypeLiteral, RankedBindings> concurrentMap = this.cachedBindings;
            synchronized (concurrentMap) {
                bindings = new RankedBindings(type, this.publishers);
                RankedBindings oldBindings = this.cachedBindings.putIfAbsent(type, bindings);
                if (oldBindings != null) {
                    bindings = oldBindings;
                }
            }
        }
        boolean isImplicit = key.getAnnotationType() == null && TypeArguments.isImplicit(type);
        return new LocatedBeans(key, bindings, isImplicit ? this.implicitBindings : null);
    }

    public synchronized void watch(Key key, Mediator mediator, Object watcher) {
        WatchedBeans beans = new WatchedBeans(key, mediator, watcher);
        for (BindingPublisher p : this.publishers()) {
            p.subscribe(beans);
        }
        this.cachedWatchers.put(beans, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(BindingPublisher publisher, int rank) {
        if (this.publishers.contains(publisher)) {
            return false;
        }
        Logs.trace("Add publisher: {}", publisher, null);
        ConcurrentMap<TypeLiteral, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            this.publishers.insert(publisher, rank);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.add(publisher, rank);
            }
        }
        for (WatchedBeans beans : new ArrayList<WatchedBeans>(this.cachedWatchers.keySet())) {
            publisher.subscribe(beans);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(BindingPublisher publisher) {
        BindingPublisher oldPublisher;
        ConcurrentMap<TypeLiteral, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            block6: {
                oldPublisher = this.publishers.remove(publisher);
                if (oldPublisher != null) break block6;
                return false;
            }
            Logs.trace("Remove publisher: {}", oldPublisher, null);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.remove(oldPublisher);
            }
        }
        for (WatchedBeans beans : this.cachedWatchers.keySet()) {
            oldPublisher.unsubscribe(beans);
        }
        return true;
    }

    @Override
    public Iterable<BindingPublisher> publishers() {
        return this.publishers.snapshot();
    }

    @Override
    public synchronized void clear() {
        for (BindingPublisher p : this.publishers()) {
            this.remove(p);
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorPublisher(injector, new DefaultRankingFunction(rank)), rank);
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorPublisher(injector, null));
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        RankingFunction function = injector.getInstance(RankingFunction.class);
        locator.add(new InjectorPublisher(injector, function), function.maxRank());
    }
}

