/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.handler.codec.http3;

import org.apache.storm.shade.io.netty.channel.ChannelInitializer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3CodecUtils;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3ConnectionHandler;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3RequestStreamCodecState;
import org.apache.storm.shade.io.netty.handler.codec.http3.Http3RequestStreamDecodeStateValidator;
import org.apache.storm.shade.io.netty.handler.codec.quic.QuicStreamChannel;

public abstract class Http3PushStreamClientInitializer
extends ChannelInitializer<QuicStreamChannel> {
    @Override
    protected final void initChannel(QuicStreamChannel ch) {
        if (Http3CodecUtils.isServerInitiatedQuicStream(ch)) {
            throw new IllegalArgumentException("Using client push stream initializer for server stream: " + ch.streamId());
        }
        Http3CodecUtils.verifyIsUnidirectional(ch);
        Http3ConnectionHandler connectionHandler = Http3CodecUtils.getConnectionHandlerOrClose(ch.parent());
        if (connectionHandler == null) {
            return;
        }
        ChannelPipeline pipeline = ch.pipeline();
        Http3RequestStreamDecodeStateValidator decodeStateValidator = new Http3RequestStreamDecodeStateValidator();
        pipeline.addLast(connectionHandler.newCodec(Http3RequestStreamCodecState.NO_STATE, decodeStateValidator));
        pipeline.addLast(decodeStateValidator);
        pipeline.addLast(connectionHandler.newPushStreamValidationHandler(ch, decodeStateValidator));
        this.initPushStream(ch);
    }

    protected abstract void initPushStream(QuicStreamChannel var1);
}

