/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.Graph;
import org.apache.storm.shade.org.jgrapht.alg.interfaces.MinimumSpanningTree;
import org.apache.storm.shade.org.jgrapht.alg.util.UnionFind;

public class KruskalMinimumSpanningTree<V, E>
implements MinimumSpanningTree<V, E> {
    private double spanningTreeCost;
    private Set<E> edgeList;

    public KruskalMinimumSpanningTree(final Graph<V, E> graph) {
        UnionFind<V> forest = new UnionFind<V>(graph.vertexSet());
        ArrayList<E> allEdges = new ArrayList<E>(graph.edgeSet());
        Collections.sort(allEdges, new Comparator<E>(){

            @Override
            public int compare(E edge1, E edge2) {
                return Double.valueOf(graph.getEdgeWeight(edge1)).compareTo(graph.getEdgeWeight(edge2));
            }
        });
        this.spanningTreeCost = 0.0;
        this.edgeList = new HashSet();
        for (E edge : allEdges) {
            V source = graph.getEdgeSource(edge);
            V target = graph.getEdgeTarget(edge);
            if (forest.find(source).equals(forest.find(target))) continue;
            forest.union(source, target);
            this.edgeList.add(edge);
            this.spanningTreeCost += graph.getEdgeWeight(edge);
        }
    }

    @Override
    public Set<E> getMinimumSpanningTreeEdgeSet() {
        return this.edgeList;
    }

    @Override
    public double getMinimumSpanningTreeTotalWeight() {
        return this.spanningTreeCost;
    }

    @Deprecated
    public Set<E> getEdgeSet() {
        return this.getMinimumSpanningTreeEdgeSet();
    }

    @Deprecated
    public double getSpanningTreeCost() {
        return this.getMinimumSpanningTreeTotalWeight();
    }
}

