/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.serialization.IKryoDecorator;
import org.apache.storm.serialization.IKryoFactory;
import org.apache.storm.serialization.SerializationRegister;
import org.apache.storm.serialization.types.ArrayListSerializer;
import org.apache.storm.serialization.types.HashMapSerializer;
import org.apache.storm.serialization.types.HashSetSerializer;
import org.apache.storm.transactional.TransactionAttempt;
import org.apache.storm.trident.tuple.ConsList;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.ListDelegate;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationFactory {
    public static final Logger LOG = LoggerFactory.getLogger(SerializationFactory.class);
    public static final ServiceLoader<SerializationRegister> loader = ServiceLoader.load(SerializationRegister.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Kryo getKryo(Map<String, Object> conf) {
        IKryoFactory kryoFactory = (IKryoFactory)ReflectionUtils.newInstance((String)conf.get("topology.kryo.factory"));
        Kryo k = kryoFactory.getKryo(conf);
        k.register(byte[].class);
        String payloadSerializerName = (String)conf.get("topology.tuple.serializer");
        try {
            Class<?> serializerClass = Class.forName(payloadSerializerName);
            Serializer serializer = SerializationFactory.resolveSerializerInstance(k, ListDelegate.class, serializerClass, conf);
            k.register(ListDelegate.class, serializer);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        k.register(ArrayList.class, (Serializer)new ArrayListSerializer());
        k.register(HashMap.class, (Serializer)new HashMapSerializer());
        k.register(HashSet.class, (Serializer)new HashSetSerializer());
        k.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        k.register(TransactionAttempt.class);
        k.register(Values.class);
        k.register(IMetricsConsumer.DataPoint.class);
        k.register(IMetricsConsumer.TaskInfo.class);
        k.register(ConsList.class);
        k.register(BackPressureStatus.class);
        k.register(NodeInfo.class);
        ServiceLoader<SerializationRegister> ex = loader;
        synchronized (ex) {
            for (SerializationRegister sr : loader) {
                try {
                    sr.register(k);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        kryoFactory.preRegister(k, conf);
        boolean skipMissing = (Boolean)conf.get("topology.skip.missing.kryo.registrations");
        SerializationFactory.register(k, conf.get("topology.kryo.register"), conf, skipMissing);
        kryoFactory.postRegister(k, conf);
        if (conf.get("topology.kryo.decorators") != null) {
            for (String klassName : (List)conf.get("topology.kryo.decorators")) {
                try {
                    Class<?> klass = Class.forName(klassName);
                    IKryoDecorator decorator = (IKryoDecorator)klass.newInstance();
                    decorator.decorate(k);
                }
                catch (ClassNotFoundException e) {
                    if (skipMissing) {
                        LOG.info("Could not find kryo decorator named " + klassName + ". Skipping registration...");
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        kryoFactory.postDecorate(k, conf);
        return k;
    }

    public static void register(Kryo k, List<String> classesToRegister) {
        SerializationFactory.register(k, classesToRegister, Collections.emptyMap(), true);
    }

    public static void register(Kryo k, Object kryoRegistrations, Map<String, Object> conf, boolean skipMissing) {
        Map<String, String> registrations = SerializationFactory.normalizeKryoRegister(kryoRegistrations);
        for (Map.Entry<String, String> entry : registrations.entrySet()) {
            String serializerClassName = entry.getValue();
            try {
                Class<?> klass = Class.forName(entry.getKey());
                Class<?> serializerClass = null;
                if (serializerClassName != null) {
                    serializerClass = Class.forName(serializerClassName);
                }
                if (serializerClass == null) {
                    k.register(klass);
                    continue;
                }
                k.register(klass, SerializationFactory.resolveSerializerInstance(k, klass, serializerClass, conf));
            }
            catch (ClassNotFoundException e) {
                if (skipMissing) {
                    LOG.info("Could not find serialization or class for " + serializerClassName + ". Skipping registration...");
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static Serializer resolveSerializerInstance(Kryo k, Class superClass, Class<? extends Serializer> serializerClass, Map<String, Object> conf) {
        try {
            return serializerClass.getConstructor(Kryo.class, Class.class, Map.class).newInstance(k, superClass, conf);
        }
        catch (Exception ex1) {
            try {
                try {
                    return serializerClass.getConstructor(Kryo.class, Class.class).newInstance(k, superClass);
                }
                catch (Exception ex2) {
                    try {
                        return serializerClass.getConstructor(Kryo.class, Map.class).newInstance(k, conf);
                    }
                    catch (Exception ex3) {
                        try {
                            return serializerClass.getConstructor(Kryo.class).newInstance(k);
                        }
                        catch (Exception ex4) {
                            try {
                                return serializerClass.getConstructor(Class.class, Map.class).newInstance(superClass, conf);
                            }
                            catch (Exception ex5) {
                                try {
                                    return serializerClass.getConstructor(Class.class).newInstance(superClass);
                                }
                                catch (Exception ex6) {
                                    return serializerClass.newInstance();
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to create serializer \"" + serializerClass.getName() + "\" for class: " + (superClass == null ? "NoSuperClass" : superClass.getName()), ex);
            }
        }
    }

    private static Map<String, String> normalizeKryoRegister(Object kryoRegistrations) {
        if (kryoRegistrations == null) {
            return new TreeMap<String, String>();
        }
        Map ret = new HashMap();
        if (kryoRegistrations instanceof Map) {
            ret = (Map)kryoRegistrations;
        } else {
            for (Object o : (List)kryoRegistrations) {
                if (o instanceof Map) {
                    ret.putAll((Map)o);
                    continue;
                }
                ret.put((String)o, null);
            }
        }
        return new TreeMap<String, String>(ret);
    }

    public static class IdDictionary {
        Map<String, Map<String, Integer>> streamNametoId = new HashMap<String, Map<String, Integer>>();
        Map<String, Map<Integer, String>> streamIdToName = new HashMap<String, Map<Integer, String>>();

        public IdDictionary(StormTopology topology) {
            ArrayList<String> componentNames = new ArrayList<String>(topology.get_spouts().keySet());
            componentNames.addAll(topology.get_bolts().keySet());
            componentNames.addAll(topology.get_state_spouts().keySet());
            for (String name : componentNames) {
                ComponentCommon common = Utils.getComponentCommon(topology, name);
                ArrayList<String> streams = new ArrayList<String>(common.get_streams().keySet());
                this.streamNametoId.put(name, IdDictionary.idify(streams));
                this.streamIdToName.put(name, IdDictionary.simpleReverseMap(this.streamNametoId.get(name)));
            }
        }

        private static <K, V> Map<V, K> simpleReverseMap(Map<K, V> map) {
            HashMap<V, K> ret = new HashMap<V, K>();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                ret.put(entry.getValue(), entry.getKey());
            }
            return ret;
        }

        private static Map<String, Integer> idify(List<String> names) {
            Collections.sort(names);
            HashMap<String, Integer> ret = new HashMap<String, Integer>();
            int i = 1;
            for (String name : names) {
                ret.put(name, i);
                ++i;
            }
            return ret;
        }

        public int getStreamId(String component, String stream) {
            return this.streamNametoId.get(component).get(stream);
        }

        public String getStreamName(String component, int stream) {
            return this.streamIdToName.get(component).get(stream);
        }
    }
}

