/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobKeySequenceInfo;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.blobstore.NimbusBlobStore;
import org.apache.storm.cluster.DaemonType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.security.auth.NimbusPrincipal;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.thrift.transport.TTransportException;
import org.apache.storm.utils.CuratorUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.WrappedKeyNotFoundException;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreUtils {
    private static final String BLOBSTORE_SUBTREE = "/blobstore";
    private static final Logger LOG = LoggerFactory.getLogger(BlobStoreUtils.class);

    public static String getBlobStoreSubtree() {
        return BLOBSTORE_SUBTREE;
    }

    public static CuratorFramework createZKClient(Map<String, Object> conf, DaemonType type) {
        List zkServers = (List)conf.get("storm.zookeeper.servers");
        Object port = conf.get("storm.zookeeper.port");
        ZookeeperAuthInfo zkAuthInfo = new ZookeeperAuthInfo(conf);
        CuratorFramework zkClient = CuratorUtils.newCurator(conf, (List)zkServers, (Object)port, (String)((String)conf.get("storm.zookeeper.root")), (ZookeeperAuthInfo)zkAuthInfo, (List)type.getDefaultZkAcls(conf));
        zkClient.start();
        return zkClient;
    }

    public static Subject getNimbusSubject() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new NimbusPrincipal());
        return subject;
    }

    public static BlobKeySequenceInfo normalizeNimbusHostPortSequenceNumberInfo(String nimbusSeqNumberInfo) {
        BlobKeySequenceInfo keySequenceInfo = new BlobKeySequenceInfo();
        int lastIndex = nimbusSeqNumberInfo.lastIndexOf("-");
        keySequenceInfo.setNimbusHostPort(nimbusSeqNumberInfo.substring(0, lastIndex));
        keySequenceInfo.setSequenceNumber(nimbusSeqNumberInfo.substring(lastIndex + 1));
        return keySequenceInfo;
    }

    public static Set<NimbusInfo> getNimbodesWithLatestSequenceNumberOfBlob(CuratorFramework zkClient, String key) throws Exception {
        List stateInfoList;
        try {
            stateInfoList = (List)zkClient.getChildren().forPath("/blobstore/" + key);
        }
        catch (KeeperException.NoNodeException e) {
            throw new WrappedKeyNotFoundException(key);
        }
        HashSet<NimbusInfo> nimbusInfoSet = new HashSet<NimbusInfo>();
        int latestSeqNumber = BlobStoreUtils.getLatestSequenceNumber(stateInfoList);
        LOG.debug("getNimbodesWithLatestSequenceNumberOfBlob stateInfo {} version {}", (Object)stateInfoList, (Object)latestSeqNumber);
        for (String state : stateInfoList) {
            BlobKeySequenceInfo sequenceInfo = BlobStoreUtils.normalizeNimbusHostPortSequenceNumberInfo(state);
            if (latestSeqNumber != Integer.parseInt(sequenceInfo.getSequenceNumber())) continue;
            nimbusInfoSet.add(NimbusInfo.parse((String)sequenceInfo.getNimbusHostPort()));
        }
        LOG.debug("nimbusInfoList {}", nimbusInfoSet);
        return nimbusInfoSet;
    }

    public static int getLatestSequenceNumber(List<String> stateInfoList) {
        int seqNumber = 0;
        for (String state : stateInfoList) {
            BlobKeySequenceInfo sequenceInfo = BlobStoreUtils.normalizeNimbusHostPortSequenceNumberInfo(state);
            int currentSeqNumber = Integer.parseInt(sequenceInfo.getSequenceNumber());
            if (seqNumber >= currentSeqNumber) continue;
            seqNumber = currentSeqNumber;
            LOG.debug("Sequence Info {}", (Object)seqNumber);
        }
        LOG.debug("Latest Sequence Number {}", (Object)seqNumber);
        return seqNumber;
    }

    public static boolean downloadMissingBlob(Map<String, Object> conf, BlobStore blobStore, String key, Set<NimbusInfo> nimbusInfos) throws TTransportException {
        boolean isSuccess = false;
        LOG.debug("Download blob NimbusInfos {}", nimbusInfos);
        block15: for (NimbusInfo nimbusInfo : nimbusInfos) {
            if (isSuccess) break;
            LOG.debug("Download blob key: {}, NimbusInfo {}", (Object)key, (Object)nimbusInfo);
            try {
                NimbusClient client = NimbusClient.Builder.withConf(conf).forDaemon().buildWithNimbusHostPort(nimbusInfo.getHost(), Integer.valueOf(nimbusInfo.getPort()));
                try {
                    ReadableBlobMeta rbm = client.getClient().getBlobMeta(key);
                    NimbusBlobStore remoteBlobStore = new NimbusBlobStore();
                    remoteBlobStore.setClient(conf, client);
                    try (InputStreamWithMeta in = remoteBlobStore.getBlob(key);){
                        blobStore.createBlob(key, (InputStream)in, rbm.get_settable(), BlobStoreUtils.getNimbusSubject());
                    }
                    Iterator keyIterator = blobStore.listKeys();
                    while (keyIterator.hasNext()) {
                        if (!((String)keyIterator.next()).equals(key)) continue;
                        LOG.debug("Success creating key, {}", (Object)key);
                        isSuccess = true;
                        continue block15;
                    }
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (IOException | AuthorizationException exception) {
                throw new RuntimeException(exception);
            }
            catch (KeyAlreadyExistsException kae) {
                LOG.info("KeyAlreadyExistsException Key: {} {}", (Object)key, (Object)kae);
                isSuccess = true;
            }
            catch (KeyNotFoundException knf) {
                LOG.info("KeyNotFoundException Key: {} {}", (Object)key, (Object)knf);
            }
            catch (Exception exp) {
                LOG.error("Exception {}", (Throwable)exp);
            }
        }
        if (!isSuccess) {
            LOG.error("Could not download the blob with key: {}", (Object)key);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadUpdatedBlob(Map<String, Object> conf, BlobStore blobStore, String key, Set<NimbusInfo> nimbusInfos) throws TTransportException {
        AtomicOutputStream out = null;
        boolean isSuccess = false;
        LOG.debug("Download blob NimbusInfos {}", nimbusInfos);
        for (NimbusInfo nimbusInfo : nimbusInfos) {
            if (isSuccess) break;
            try {
                NimbusClient client = NimbusClient.Builder.withConf(conf).forDaemon().buildWithNimbusHostPort(nimbusInfo.getHost(), Integer.valueOf(nimbusInfo.getPort()));
                try {
                    NimbusBlobStore remoteBlobStore = new NimbusBlobStore();
                    remoteBlobStore.setClient(conf, client);
                    try (InputStreamWithMeta in = remoteBlobStore.getBlob(key);){
                        out = blobStore.updateBlob(key, BlobStoreUtils.getNimbusSubject());
                        byte[] buffer = new byte[2048];
                        int len = 0;
                        while ((len = in.read(buffer)) > 0) {
                            out.write(buffer, 0, len);
                        }
                        out.close();
                        out = null;
                    }
                    isSuccess = true;
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (FileNotFoundException fnf) {
                LOG.warn("Blobstore file for key '{}' does not exist or got deleted before it could be downloaded.", (Object)key, (Object)fnf);
            }
            catch (IOException | AuthorizationException exception) {
                throw new RuntimeException(exception);
            }
            catch (KeyNotFoundException knf) {
                LOG.info("KeyNotFoundException", (Throwable)knf);
            }
            catch (Exception exp) {
                LOG.error("Exception", (Throwable)exp);
            }
            finally {
                if (out == null) continue;
                try {
                    out.cancel();
                }
                catch (IOException fnf) {}
            }
        }
        if (!isSuccess) {
            LOG.error("Could not update the blob with key: {}", (Object)key);
        }
        return isSuccess;
    }

    public static List<String> getKeyListFromBlobStore(BlobStore blobStore) throws Exception {
        Iterator keys = blobStore.listKeys();
        ArrayList<String> keyList = new ArrayList<String>();
        if (keys != null) {
            while (keys.hasNext()) {
                keyList.add((String)keys.next());
            }
        }
        LOG.debug("KeyList from blobstore {}", keyList);
        return keyList;
    }

    public static void createStateInZookeeper(Map<String, Object> conf, String key, NimbusInfo nimbusInfo) throws TTransportException {
        NimbusBlobStore cb = new NimbusBlobStore();
        cb.setClient(conf, NimbusClient.Builder.withConf(conf).forDaemon().buildWithNimbusHostPort(nimbusInfo.getHost(), Integer.valueOf(nimbusInfo.getPort())));
        cb.createStateInZookeeper(key);
    }

    public static void updateKeyForBlobStore(Map<String, Object> conf, BlobStore blobStore, CuratorFramework zkClient, String key, NimbusInfo nimbusDetails) {
        try {
            if (nimbusDetails == null) {
                return;
            }
            boolean isListContainsCurrentNimbusInfo = false;
            if (zkClient.checkExists().forPath("/blobstore/" + key) == null) {
                return;
            }
            List stateInfo = (List)zkClient.getChildren().forPath("/blobstore/" + key);
            if (stateInfo == null || stateInfo.isEmpty()) {
                return;
            }
            LOG.debug("StateInfo for update {}", (Object)stateInfo);
            Set<NimbusInfo> nimbusInfoList = BlobStoreUtils.getNimbodesWithLatestSequenceNumberOfBlob(zkClient, key);
            for (NimbusInfo nimbusInfo : nimbusInfoList) {
                if (!nimbusInfo.getHost().equals(nimbusDetails.getHost())) continue;
                isListContainsCurrentNimbusInfo = true;
                break;
            }
            if (!isListContainsCurrentNimbusInfo && BlobStoreUtils.downloadUpdatedBlob(conf, blobStore, key, nimbusInfoList)) {
                LOG.debug("Updating state inside zookeeper for an update");
                BlobStoreUtils.createStateInZookeeper(conf, key, nimbusDetails);
            }
        }
        catch (KeyNotFoundException | KeeperException.NoNodeException e) {
            return;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }
}

