/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.oci;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.storm.Config;
import org.apache.storm.DaemonConfig;
import org.apache.storm.container.ResourceIsolationInterface;
import org.apache.storm.container.cgroup.core.MemoryCore;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ServerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OciContainerManager
implements ResourceIsolationInterface {
    private static final Logger LOG = LoggerFactory.getLogger(OciContainerManager.class);
    protected Map<String, Object> conf;
    protected List<String> readonlyBindmounts;
    protected List<String> readwriteBindmounts;
    protected String seccompJsonFile;
    protected String nscdPath;
    protected static final String TMP_DIR = File.separator + "tmp";
    protected String stormHome;
    protected String cgroupRootPath;
    protected String cgroupParent;
    protected String memoryCgroupRootPath;
    protected MemoryCore memoryCoreAtRoot;
    protected Map<String, Integer> workerToCpu = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Integer> workerToMemoryMb = new ConcurrentHashMap<String, Integer>();
    protected Map<String, Object> validatedNumaMap = new ConcurrentHashMap<String, Object>();
    protected Map<String, List<String>> workerToCores = new ConcurrentHashMap<String, List<String>>();
    protected Map<String, String> workerToMemoryZone = new ConcurrentHashMap<String, String>();

    @Override
    public void prepare(Map<String, Object> conf) throws IOException {
        this.conf = conf;
        this.readonlyBindmounts = ObjectReader.getStrings((Object)conf.get(DaemonConfig.STORM_OCI_READONLY_BINDMOUNTS));
        this.readwriteBindmounts = ObjectReader.getStrings((Object)conf.get(DaemonConfig.STORM_OCI_READWRITE_BINDMOUNTS));
        this.seccompJsonFile = (String)conf.get(DaemonConfig.STORM_OCI_SECCOMP_PROFILE);
        this.nscdPath = ObjectReader.getString((Object)conf.get(DaemonConfig.STORM_OCI_NSCD_DIR));
        this.stormHome = System.getProperty("storm.home");
        this.cgroupRootPath = ObjectReader.getString((Object)conf.get(Config.STORM_OCI_CGROUP_ROOT));
        this.cgroupParent = ObjectReader.getString((Object)conf.get(DaemonConfig.STORM_OCI_CGROUP_PARENT));
        if (!this.cgroupParent.startsWith(File.separator)) {
            this.cgroupParent = File.separator + this.cgroupParent;
            LOG.warn("{} is not an absolute path. Changing it to be absolute: {}", (Object)DaemonConfig.STORM_OCI_CGROUP_PARENT, (Object)this.cgroupParent);
        }
        this.memoryCgroupRootPath = this.cgroupRootPath + File.separator + "memory" + File.separator + this.cgroupParent;
        this.memoryCoreAtRoot = new MemoryCore(this.memoryCgroupRootPath);
        this.validatedNumaMap = SupervisorUtils.getNumaMap(conf);
    }

    @Override
    public void reserveResourcesForWorker(String workerId, Integer workerMemoryMb, Integer workerCpu, String numaId) {
        if (this.conf.get(DaemonConfig.STORM_WORKER_CGROUP_CPU_LIMIT) != null) {
            workerCpu = ((Number)this.conf.get(DaemonConfig.STORM_WORKER_CGROUP_CPU_LIMIT)).intValue();
        }
        this.workerToCpu.put(workerId, workerCpu);
        if (((Boolean)this.conf.get(DaemonConfig.STORM_CGROUP_MEMORY_ENFORCEMENT_ENABLE)).booleanValue()) {
            this.workerToMemoryMb.put(workerId, workerMemoryMb);
        }
        if (numaId != null) {
            Map numaIdEntry = (Map)this.validatedNumaMap.get(numaId);
            List rawCores = ((List)numaIdEntry.get("numa.cores")).stream().map(rawCore -> String.valueOf(rawCore)).collect(Collectors.toList());
            this.workerToCores.put(workerId, rawCores);
            this.workerToMemoryZone.put(workerId, numaId);
        }
    }

    @Override
    public void cleanup(String user, String workerId, int port) throws IOException {
        this.workerToCpu.remove(workerId);
        this.workerToMemoryMb.remove(workerId);
        this.workerToCores.remove(workerId);
        this.workerToMemoryZone.remove(workerId);
    }

    @Override
    public long getSystemFreeMemoryMb() throws IOException {
        long rootCgroupLimitFree = Long.MAX_VALUE;
        try {
            long limit = this.memoryCoreAtRoot.getPhysicalUsageLimit();
            long used = this.memoryCoreAtRoot.getMaxPhysicalUsage();
            rootCgroupLimitFree = (limit - used) / 1024L / 1024L;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return Long.min(rootCgroupLimitFree, ServerUtils.getMemInfoFreeMb());
    }

    protected String getImageName(Map<String, Object> topoConf) {
        return (String)topoConf.get(Config.TOPOLOGY_OCI_IMAGE);
    }

    protected String commandFilePath(String dir, String commandTag) {
        return dir + File.separator + commandTag + ".sh";
    }

    protected String writeToCommandFile(String workerDir, String command, String commandTag) throws IOException {
        String scriptPath = this.commandFilePath(workerDir, commandTag);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(scriptPath));){
            out.write(command);
        }
        LOG.debug("command : {}; location: {}", (Object)command, (Object)scriptPath);
        return scriptPath;
    }

    protected static enum CmdType {
        LAUNCH_DOCKER_CONTAINER("launch-docker-container"),
        RUN_DOCKER_CMD("run-docker-cmd"),
        PROFILE_DOCKER_CONTAINER("profile-docker-container"),
        RUN_OCI_CONTAINER("run-oci-container"),
        REAP_OCI_CONTAINER("reap-oci-container"),
        PROFILE_OCI_CONTAINER("profile-oci-container");

        private final String name;

        private CmdType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

