/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.nio.file.Path;
import net.sf.jasperreports.repo.ResourceInfo;

public class StandardResourceInfo
implements ResourceInfo {
    private String resourceLocation;
    private String contextLocation;

    public static StandardResourceInfo from(File resourceFile) {
        StandardResourceInfo info = new StandardResourceInfo();
        info.setRepositoryResourceLocation(resourceFile.getPath());
        info.setRepositoryContextLocation(resourceFile.getParent());
        return info;
    }

    public static StandardResourceInfo from(Path resourcePath) {
        StandardResourceInfo info = new StandardResourceInfo();
        info.setRepositoryResourceLocation(resourcePath.toString());
        Path parentPath = resourcePath.getParent();
        info.setRepositoryContextLocation(parentPath == null ? null : parentPath.toString());
        return info;
    }

    @Override
    public String getRepositoryResourceLocation() {
        return this.resourceLocation;
    }

    public void setRepositoryResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    @Override
    public String getRepositoryContextLocation() {
        return this.contextLocation;
    }

    public void setRepositoryContextLocation(String contextLocation) {
        this.contextLocation = contextLocation;
    }
}

